/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.lmax.disruptor.EventFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMNotificationRouterEvent {
    private static final Logger LOG = LoggerFactory.getLogger(DOMNotificationRouterEvent.class);
    public static final EventFactory<DOMNotificationRouterEvent> FACTORY = DOMNotificationRouterEvent::new;
    private Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers;
    private DOMNotification notification;
    private SettableFuture<Void> future;

    private DOMNotificationRouterEvent() {
    }

    ListenableFuture<Void> initialize(DOMNotification notification, Collection<ListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        this.notification = (DOMNotification)Preconditions.checkNotNull((Object)notification);
        this.subscribers = (Collection)Preconditions.checkNotNull(subscribers);
        this.future = SettableFuture.create();
        return this.future;
    }

    void deliverNotification() {
        LOG.trace("Start delivery of notification {}", (Object)this.notification);
        for (ListenerRegistration<? extends DOMNotificationListener> r : this.subscribers) {
            DOMNotificationListener listener = (DOMNotificationListener)r.getInstance();
            LOG.trace("Notifying listener {}", (Object)listener);
            listener.onNotification(this.notification);
            LOG.trace("Listener notification completed");
        }
        LOG.trace("Delivery completed");
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="Void is the only allowed value")
    void setFuture() {
        this.future.set(null);
        this.notification = null;
        this.subscribers = null;
        this.future = null;
    }
}

