/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcIdentifier;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcImplementation;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.broker.impl.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

final class GlobalDOMRpcRoutingTableEntry
extends AbstractDOMRpcRoutingTableEntry {
    private final DOMRpcIdentifier rpcId;

    private GlobalDOMRpcRoutingTableEntry(DOMRpcIdentifier rpcId, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        super(rpcId.getType(), impls);
        this.rpcId = (DOMRpcIdentifier)Preconditions.checkNotNull((Object)rpcId);
    }

    GlobalDOMRpcRoutingTableEntry(RpcDefinition def, Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        super(def.getPath(), impls);
        this.rpcId = DOMRpcIdentifier.create((SchemaPath)def.getPath());
    }

    @Override
    protected CheckedFuture<DOMRpcResult, DOMRpcException> invokeRpc(NormalizedNode<?, ?> input) {
        return this.getImplementations(YangInstanceIdentifier.EMPTY).get(0).invokeRpc(this.rpcId, input);
    }

    @Override
    protected GlobalDOMRpcRoutingTableEntry newInstance(Map<YangInstanceIdentifier, List<DOMRpcImplementation>> impls) {
        return new GlobalDOMRpcRoutingTableEntry(this.rpcId, impls);
    }
}

