/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBrokerExtension;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter.ShardedDOMDataBrokerDelegatingReadTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter.ShardedDOMDataBrokerDelegatingReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter.ShardedDOMDataBrokerDelegatingTransactionChain;
import org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter.ShardedDOMDataBrokerDelegatingWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.ShardedDOMDataBrokerAdapter;

public class LegacyShardedDOMDataBrokerAdapter
implements DOMDataBroker {
    private final org.opendaylight.mdsal.dom.api.DOMDataBroker delegateDataBroker;
    private final DOMSchemaService schemaService;
    private final AtomicLong txNum = new AtomicLong();
    private final AtomicLong chainNum = new AtomicLong();

    public LegacyShardedDOMDataBrokerAdapter(ShardedDOMDataBrokerAdapter delegateDataBroker, DOMSchemaService schemaService) {
        this.delegateDataBroker = (org.opendaylight.mdsal.dom.api.DOMDataBroker)Preconditions.checkNotNull((Object)delegateDataBroker);
        this.schemaService = (DOMSchemaService)Preconditions.checkNotNull((Object)schemaService);
    }

    public DOMDataReadOnlyTransaction newReadOnlyTransaction() {
        return new ShardedDOMDataBrokerDelegatingReadTransaction(this.newTransactionIdentifier(), this.delegateDataBroker.newReadOnlyTransaction());
    }

    public DOMDataReadWriteTransaction newReadWriteTransaction() {
        return new ShardedDOMDataBrokerDelegatingReadWriteTransaction(this.newTransactionIdentifier(), this.schemaService.getGlobalContext(), this.newReadOnlyTransaction(), this.newWriteOnlyTransaction());
    }

    public DOMDataWriteTransaction newWriteOnlyTransaction() {
        return new ShardedDOMDataBrokerDelegatingWriteTransaction(this.newTransactionIdentifier(), this.delegateDataBroker.newWriteOnlyTransaction());
    }

    public DOMTransactionChain createTransactionChain(TransactionChainListener listener) {
        return new ShardedDOMDataBrokerDelegatingTransactionChain(this.chainNum.getAndIncrement(), this.schemaService.getGlobalContext(), this.delegateDataBroker, listener);
    }

    public Map<Class<? extends DOMDataBrokerExtension>, DOMDataBrokerExtension> getSupportedExtensions() {
        return Collections.emptyMap();
    }

    private Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }
}

