/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.ReadFailedException;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

class ShardedDOMDataBrokerDelegatingReadTransaction
implements DOMDataReadOnlyTransaction {
    private final DOMDataTreeReadTransaction delegateTx;
    private final Object txIdentifier;

    ShardedDOMDataBrokerDelegatingReadTransaction(Object txIdentifier, DOMDataTreeReadTransaction delegateTx) {
        this.delegateTx = (DOMDataTreeReadTransaction)Preconditions.checkNotNull((Object)delegateTx);
        this.txIdentifier = Preconditions.checkNotNull((Object)txIdentifier);
    }

    public CheckedFuture<Optional<NormalizedNode<?, ?>>, ReadFailedException> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return Futures.makeChecked((ListenableFuture)this.delegateTx.read(store.toMdsal(), path).transform(Optional::fromJavaUtil, MoreExecutors.directExecutor()), (Function)ReadFailedException.MAPPER);
    }

    public CheckedFuture<Boolean, ReadFailedException> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return Futures.makeChecked((ListenableFuture)this.delegateTx.exists(store.toMdsal(), path), (Function)ReadFailedException.MAPPER);
    }

    public Object getIdentifier() {
        return this.txIdentifier;
    }

    public void close() {
        this.delegateTx.close();
    }
}

