/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.broker.impl.legacy.sharded.adapter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

class ShardedDOMDataBrokerDelegatingWriteTransaction
implements DOMDataWriteTransaction {
    private final DOMDataTreeWriteTransaction delegateTx;
    private final Object txIdentifier;

    ShardedDOMDataBrokerDelegatingWriteTransaction(Object txIdentifier, DOMDataTreeWriteTransaction delegateTx) {
        this.delegateTx = (DOMDataTreeWriteTransaction)Preconditions.checkNotNull((Object)delegateTx);
        this.txIdentifier = Preconditions.checkNotNull((Object)txIdentifier);
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.delegateTx.put(store.toMdsal(), path, data);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.delegateTx.merge(store.toMdsal(), path, data);
    }

    public boolean cancel() {
        return this.delegateTx.cancel();
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.delegateTx.delete(store.toMdsal(), path);
    }

    public FluentFuture<? extends CommitInfo> commit() {
        return this.delegateTx.commit();
    }

    public Object getIdentifier() {
        return this.txIdentifier;
    }
}

