/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.dom.broker.impl;

import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;

public final class SchemaContextProviders {
    private SchemaContextProviders() {
        throw new UnsupportedOperationException("Utility class.");
    }

    public static SchemaContextProvider fromSchemaService(DOMSchemaService schemaService) {
        if (schemaService instanceof SchemaContextProvider) {
            return (SchemaContextProvider)schemaService;
        }
        return new SchemaServiceAdapter(schemaService);
    }

    private static final class SchemaServiceAdapter
    implements SchemaContextProvider,
    Delegator<DOMSchemaService> {
        private final DOMSchemaService service;

        SchemaServiceAdapter(DOMSchemaService service) {
            this.service = service;
        }

        public SchemaContext getSchemaContext() {
            return this.service.getGlobalContext();
        }

        public DOMSchemaService getDelegate() {
            return this.service;
        }

        public String toString() {
            return "SchemaServiceAdapter [service=" + this.service + "]";
        }
    }
}

