/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.dom.spi;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

@Beta
public final class DefaultDOMRpcResult
implements DOMRpcResult,
Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final Collection<? extends RpcError> errors;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final NormalizedNode<?, ?> result;

    private static Collection<RpcError> asCollection(RpcError ... errors) {
        if (errors.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(errors);
    }

    public DefaultDOMRpcResult(NormalizedNode<?, ?> result, RpcError ... errors) {
        this(result, DefaultDOMRpcResult.asCollection(errors));
    }

    public DefaultDOMRpcResult(RpcError ... errors) {
        this(null, DefaultDOMRpcResult.asCollection(errors));
    }

    public DefaultDOMRpcResult(NormalizedNode<?, ?> result) {
        this(result, Collections.emptyList());
    }

    public DefaultDOMRpcResult(NormalizedNode<?, ?> result, @NonNull Collection<? extends RpcError> errors) {
        this.result = result;
        this.errors = Objects.requireNonNull(errors);
    }

    public DefaultDOMRpcResult(@NonNull Collection<RpcError> errors) {
        this(null, errors);
    }

    public Collection<? extends RpcError> getErrors() {
        return this.errors;
    }

    public NormalizedNode<?, ?> getResult() {
        return this.result;
    }

    public int hashCode() {
        int ret = this.errors.hashCode();
        if (this.result != null) {
            ret = 31 * ret + this.result.hashCode();
        }
        return ret;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultDOMRpcResult)) {
            return false;
        }
        DefaultDOMRpcResult other = (DefaultDOMRpcResult)obj;
        if (!this.errors.equals(other.errors)) {
            return false;
        }
        return Objects.equals(this.result, other.result);
    }
}

