/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.core.spi.data;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreTransactionChain;
import org.opendaylight.controller.sal.core.spi.data.DOMStoreWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedReadTransaction;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedReadWriteTransaction;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedTransactions;
import org.opendaylight.controller.sal.core.spi.data.SnapshotBackedWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractSnapshotBackedTransactionChain<T>
extends SnapshotBackedWriteTransaction.TransactionReadyPrototype<T>
implements DOMStoreTransactionChain,
SnapshotBackedReadTransaction.TransactionClosePrototype<T> {
    private static final AtomicReferenceFieldUpdater<AbstractSnapshotBackedTransactionChain, State> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AbstractSnapshotBackedTransactionChain.class, State.class, "state");
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSnapshotBackedTransactionChain.class);
    private static final Shutdown CLOSED = new Shutdown("Transaction chain is closed");
    private static final Shutdown FAILED = new Shutdown("Transaction chain has failed");
    private final Idle idleState = new Idle(this);
    private volatile State state = this.idleState;

    protected AbstractSnapshotBackedTransactionChain() {
    }

    private Map.Entry<State, DataTreeSnapshot> getSnapshot(T transactionId) {
        State localState = this.state;
        return new AbstractMap.SimpleEntry<State, DataTreeSnapshot>(localState, localState.getSnapshot(transactionId));
    }

    private boolean recordTransaction(State expected, DOMStoreWriteTransaction transaction) {
        Allocated localState = new Allocated(transaction);
        return STATE_UPDATER.compareAndSet(this, expected, localState);
    }

    @Override
    public final DOMStoreReadTransaction newReadOnlyTransaction() {
        return this.newReadOnlyTransaction(this.nextTransactionIdentifier());
    }

    protected DOMStoreReadTransaction newReadOnlyTransaction(T transactionId) {
        Map.Entry<State, DataTreeSnapshot> entry = this.getSnapshot(transactionId);
        return SnapshotBackedTransactions.newReadTransaction(transactionId, this.getDebugTransactions(), entry.getValue(), this);
    }

    @Override
    public void transactionClosed(SnapshotBackedReadTransaction<T> tx) {
    }

    @Override
    public final DOMStoreReadWriteTransaction newReadWriteTransaction() {
        return this.newReadWriteTransaction(this.nextTransactionIdentifier());
    }

    protected DOMStoreReadWriteTransaction newReadWriteTransaction(T transactionId) {
        SnapshotBackedReadWriteTransaction<T> ret;
        Map.Entry<State, DataTreeSnapshot> entry;
        do {
            entry = this.getSnapshot(transactionId);
            ret = new SnapshotBackedReadWriteTransaction<T>(transactionId, this.getDebugTransactions(), entry.getValue(), this);
        } while (!this.recordTransaction(entry.getKey(), ret));
        return ret;
    }

    @Override
    public final DOMStoreWriteTransaction newWriteOnlyTransaction() {
        return this.newWriteOnlyTransaction(this.nextTransactionIdentifier());
    }

    protected DOMStoreWriteTransaction newWriteOnlyTransaction(T transactionId) {
        SnapshotBackedWriteTransaction<T> ret;
        Map.Entry<State, DataTreeSnapshot> entry;
        do {
            entry = this.getSnapshot(transactionId);
            ret = new SnapshotBackedWriteTransaction<T>(transactionId, this.getDebugTransactions(), entry.getValue(), this);
        } while (!this.recordTransaction(entry.getKey(), ret));
        return ret;
    }

    @Override
    protected final void transactionAborted(SnapshotBackedWriteTransaction<T> tx) {
        boolean success;
        Allocated allocated;
        State localState = this.state;
        if (localState instanceof Allocated && (allocated = (Allocated)localState).getTransaction().equals(tx) && !(success = STATE_UPDATER.compareAndSet(this, localState, this.idleState))) {
            LOG.warn("Transaction {} aborted, but chain {} state already transitioned from {} to {}, very strange", new Object[]{tx, this, localState, this.state});
        }
    }

    @Override
    protected final DOMStoreThreePhaseCommitCohort transactionReady(SnapshotBackedWriteTransaction<T> tx, DataTreeModification tree, Exception readyError) {
        State localState = this.state;
        if (localState instanceof Allocated) {
            Allocated allocated = (Allocated)localState;
            DOMStoreWriteTransaction transaction = allocated.getTransaction();
            Preconditions.checkState((boolean)tx.equals(transaction), (String)"Mis-ordered ready transaction %s last allocated was %s", tx, (Object)transaction);
            allocated.setSnapshot((DataTreeSnapshot)tree);
        } else {
            LOG.debug("Ignoring transaction {} readiness due to state {}", tx, (Object)localState);
        }
        return this.createCohort(tx, tree, readyError);
    }

    @Override
    public final void close() {
        State localState = this.state;
        do {
            Preconditions.checkState((!CLOSED.equals(localState) ? 1 : 0) != 0, (String)"Transaction chain %s has been closed", (Object)this);
            if (!FAILED.equals(localState)) continue;
            LOG.debug("Ignoring user close in failed state");
            return;
        } while (!STATE_UPDATER.compareAndSet(this, localState, CLOSED));
    }

    protected final void onTransactionCommited(SnapshotBackedWriteTransaction<T> transaction) {
        State localState = this.state;
        if (!(localState instanceof Allocated)) {
            LOG.debug("Ignoring successful transaction {} in state {}", transaction, (Object)localState);
            return;
        }
        Allocated allocated = (Allocated)localState;
        DOMStoreWriteTransaction tx = allocated.getTransaction();
        if (!tx.equals(transaction)) {
            LOG.debug("Ignoring non-latest successful transaction {} in state {}", transaction, (Object)allocated);
            return;
        }
        if (!STATE_UPDATER.compareAndSet(this, localState, this.idleState)) {
            LOG.debug("Transaction chain {} has already transitioned from {} to {}, not making it idle", new Object[]{this, localState, this.state});
        }
    }

    protected final void onTransactionFailed(SnapshotBackedWriteTransaction<T> transaction, Throwable cause) {
        LOG.debug("Transaction chain {} failed on transaction {}", new Object[]{this, transaction, cause});
        this.state = FAILED;
    }

    protected abstract T nextTransactionIdentifier();

    protected abstract boolean getDebugTransactions();

    protected abstract DataTreeSnapshot takeSnapshot();

    protected abstract DOMStoreThreePhaseCommitCohort createCohort(SnapshotBackedWriteTransaction<T> var1, DataTreeModification var2, Exception var3);

    private static final class Shutdown
    extends State {
        private final String message;

        Shutdown(String message) {
            this.message = (String)Preconditions.checkNotNull((Object)message);
        }

        @Override
        protected DataTreeSnapshot getSnapshot(Object transactionId) {
            throw new IllegalStateException(this.message);
        }
    }

    private static final class Allocated
    extends State {
        private static final AtomicReferenceFieldUpdater<Allocated, DataTreeSnapshot> SNAPSHOT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Allocated.class, DataTreeSnapshot.class, "snapshot");
        private final DOMStoreWriteTransaction transaction;
        private volatile DataTreeSnapshot snapshot;

        Allocated(DOMStoreWriteTransaction transaction) {
            this.transaction = (DOMStoreWriteTransaction)Preconditions.checkNotNull((Object)transaction);
        }

        public DOMStoreWriteTransaction getTransaction() {
            return this.transaction;
        }

        @Override
        protected DataTreeSnapshot getSnapshot(Object transactionId) {
            DataTreeSnapshot ret = this.snapshot;
            Preconditions.checkState((ret != null ? 1 : 0) != 0, (String)"Could not get snapshot for transaction %s - previous transaction %s is not ready yet", (Object)transactionId, (Object)this.transaction.getIdentifier());
            return ret;
        }

        void setSnapshot(DataTreeSnapshot snapshot) {
            boolean success = SNAPSHOT_UPDATER.compareAndSet(this, null, snapshot);
            Preconditions.checkState((boolean)success, (String)"Transaction %s has already been marked as ready", (Object)this.transaction.getIdentifier());
        }
    }

    private static final class Idle
    extends State {
        private final AbstractSnapshotBackedTransactionChain<?> chain;

        Idle(AbstractSnapshotBackedTransactionChain<?> chain) {
            this.chain = (AbstractSnapshotBackedTransactionChain)Preconditions.checkNotNull(chain);
        }

        @Override
        protected DataTreeSnapshot getSnapshot(Object transactionId) {
            return this.chain.takeSnapshot();
        }
    }

    private static abstract class State {
        private State() {
        }

        protected abstract DataTreeSnapshot getSnapshot(Object var1);
    }
}

