/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.obr.command.ObrCommandSupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="obr", name="find", description="Find OBR bundles for a given filter.")
@Service
public class FindCommand
extends ObrCommandSupport {
    @Argument(index=0, name="requirements", description="Requirement", required=true, multiValued=true)
    List<String> requirements;

    @Override
    protected void doExecute(RepositoryAdmin admin) throws Exception {
        Resource[] resources = admin.discoverResources(this.parseRequirements(admin, this.requirements));
        if (resources == null) {
            System.err.println("No matching resources.");
        } else {
            for (int resIdx = 0; resIdx < resources.length; ++resIdx) {
                if (resIdx > 0) {
                    System.out.println("");
                }
                this.printResource(System.out, resources[resIdx]);
            }
        }
    }

    private void printResource(PrintStream out, Resource resource) {
        Capability[] caps;
        String name = resource.getPresentationName();
        if (name == null) {
            name = resource.getSymbolicName();
        }
        this.printUnderline(out, name.length());
        out.println(name);
        this.printUnderline(out, name.length());
        Map map = resource.getProperties();
        for (Map.Entry o : map.entrySet()) {
            Map.Entry entry = o;
            if (entry.getValue().getClass().isArray()) {
                out.println(entry.getKey() + ":");
                for (int j = 0; j < Array.getLength(entry.getValue()); ++j) {
                    out.println("   " + Array.get(entry.getValue(), j));
                }
                continue;
            }
            out.println(entry.getKey() + ": " + entry.getValue());
        }
        Requirement[] reqs = resource.getRequirements();
        if (reqs != null && reqs.length > 0) {
            boolean hdr = false;
            for (Requirement requirement : reqs) {
                if (requirement.isOptional()) continue;
                if (!hdr) {
                    hdr = true;
                    out.println("Requirements:");
                }
                out.println("   " + requirement.getName() + ":" + requirement.getFilter());
            }
            hdr = false;
            for (Requirement requirement : reqs) {
                if (!requirement.isOptional()) continue;
                if (!hdr) {
                    hdr = true;
                    out.println("Optional Requirements:");
                }
                out.println("   " + requirement.getName() + ":" + requirement.getFilter());
            }
        }
        if ((caps = resource.getCapabilities()) != null && caps.length > 0) {
            out.println("Capabilities:");
            for (Requirement requirement : caps) {
                out.println("   " + requirement.getName() + ":" + requirement.getPropertiesAsMap());
            }
        }
    }
}

