/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.obr.command;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.List;
import org.apache.felix.bundlerepository.Reason;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resolver;
import org.apache.felix.bundlerepository.Resource;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public abstract class ObrCommandSupport
implements Action {
    protected static final char VERSION_DELIM = ',';
    @Reference
    private RepositoryAdmin repositoryAdmin;
    @Reference
    BundleContext bundleContext;
    public static final String REPOSITORY_URL_PROP = "obr.repository.url";

    public void setRepositoryAdmin(RepositoryAdmin repositoryAdmin) {
        this.repositoryAdmin = repositoryAdmin;
    }

    public Object execute() throws Exception {
        this.doExecute(this.repositoryAdmin);
        return null;
    }

    abstract void doExecute(RepositoryAdmin var1) throws Exception;

    protected Resource[] searchRepository(RepositoryAdmin admin, String targetId, String targetVersion) throws InvalidSyntaxException {
        try {
            Bundle bundle = this.bundleContext.getBundle(Long.parseLong(targetId));
            targetId = bundle.getSymbolicName();
        }
        catch (NumberFormatException bundle) {
            // empty catch block
        }
        StringBuffer sb = new StringBuffer("(|(presentationname=");
        sb.append(targetId);
        sb.append(")(symbolicname=");
        sb.append(targetId);
        sb.append("))");
        if (targetVersion != null) {
            sb.insert(0, "(&");
            sb.append("(version=");
            sb.append(targetVersion);
            sb.append("))");
        }
        return admin.discoverResources(sb.toString());
    }

    public Resource selectNewestVersion(Resource[] resources) {
        int idx = -1;
        Version v = null;
        for (int i = 0; resources != null && i < resources.length; ++i) {
            if (i == 0) {
                idx = 0;
                v = resources[i].getVersion();
                continue;
            }
            Version vtmp = resources[i].getVersion();
            if (vtmp.compareTo(v) <= 0) continue;
            idx = i;
            v = vtmp;
        }
        return idx < 0 ? null : resources[idx];
    }

    protected String[] getTarget(String bundle) {
        int idx = bundle.indexOf(44);
        String[] target = idx > 0 ? new String[]{bundle.substring(0, idx), bundle.substring(idx + 1)} : new String[]{bundle, null};
        return target;
    }

    protected void printUnderline(PrintStream out, int length) {
        for (int i = 0; i < length; ++i) {
            out.print('-');
        }
        out.println("");
    }

    protected void doDeploy(RepositoryAdmin admin, List<String> bundles, boolean start, boolean deployOptional) throws Exception {
        Resolver resolver = admin.resolver();
        for (String bundle : bundles) {
            String[] target = this.getTarget(bundle);
            Resource resource = this.selectNewestVersion(this.searchRepository(admin, target[0], target[1]));
            if (resource != null) {
                resolver.add(resource);
                continue;
            }
            System.err.println("Unknown bundle - " + target[0]);
        }
        if (resolver.getAddedResources() != null && resolver.getAddedResources().length > 0) {
            if (resolver.resolve(deployOptional ? 0 : 1)) {
                System.out.println("Target resource(s):");
                this.printUnderline(System.out, 19);
                Resource[] resources = resolver.getAddedResources();
                for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
                    System.out.println("   " + this.getResourceId(resources[resIdx]) + " (" + resources[resIdx].getVersion() + ")");
                }
                resources = resolver.getRequiredResources();
                if (resources != null && resources.length > 0) {
                    System.out.println("\nRequired resource(s):");
                    this.printUnderline(System.out, 21);
                    for (Resource resource : resources) {
                        System.out.println("   " + this.getResourceId(resource) + " (" + resource.getVersion() + ")");
                    }
                }
                if (deployOptional && (resources = resolver.getOptionalResources()) != null && resources.length > 0) {
                    System.out.println("\nOptional resource(s):");
                    this.printUnderline(System.out, 21);
                    for (Resource resource : resources) {
                        System.out.println("   " + this.getResourceId(resource) + " (" + resource.getVersion() + ")");
                    }
                }
                try {
                    System.out.print("\nDeploying...");
                    resolver.deploy(start ? 16 : 0);
                    System.out.println("done.");
                }
                catch (IllegalStateException ex) {
                    System.err.println(ex);
                }
            } else {
                Reason[] reqs = resolver.getUnsatisfiedRequirements();
                if (reqs != null && reqs.length > 0) {
                    System.out.println("Unsatisfied requirement(s):");
                    this.printUnderline(System.out, 27);
                    for (Reason req : reqs) {
                        System.out.println("   " + req.getRequirement().getFilter());
                        System.out.println("      " + this.getResourceId(req.getResource()));
                    }
                } else {
                    System.out.println("Could not resolve targets.");
                }
            }
        }
    }

    protected String getResourceId(Resource resource) {
        return resource.getPresentationName() != null ? resource.getPresentationName() : resource.getSymbolicName();
    }

    protected Requirement parseRequirement(RepositoryAdmin admin, String req) throws InvalidSyntaxException {
        String filter;
        String name;
        int p = req.indexOf(58);
        if (p > 0) {
            name = req.substring(0, p);
            filter = req.substring(p + 1);
        } else {
            name = req.contains("package") ? "package" : (req.contains("service") ? "service" : (req.contains("osgi.extender") ? "osgi.extender" : "bundle"));
            filter = req;
        }
        if (!filter.startsWith("(")) {
            filter = "(" + filter + ")";
        }
        return admin.getHelper().requirement(name, filter);
    }

    protected Requirement[] parseRequirements(RepositoryAdmin admin, List<String> requirements) throws InvalidSyntaxException {
        Requirement[] reqs = new Requirement[requirements.size()];
        for (int i = 0; i < reqs.length; ++i) {
            reqs[i] = this.parseRequirement(admin, requirements.get(i));
        }
        return reqs;
    }

    protected void persistRepositoryList(RepositoryAdmin admin) {
        try {
            StringBuilder sb = new StringBuilder();
            for (Repository repo : admin.listRepositories()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(repo.getURI());
            }
            File etc = new File(System.getProperty("karaf.etc"));
            File sys = new File(etc, "config.properties");
            File sysTmp = new File(etc, "config.properties.tmp");
            boolean modified = false;
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(sysTmp)));){
                if (sys.exists()) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(sys)));){
                        String line = reader.readLine();
                        while (line != null) {
                            if (line.matches("obr\\.repository\\.url[:= ].*")) {
                                modified = true;
                                line = "obr.repository.url = " + sb.toString();
                            }
                            writer.write(line);
                            writer.newLine();
                            line = reader.readLine();
                        }
                    }
                }
                if (!modified) {
                    writer.newLine();
                    writer.write("# ");
                    writer.newLine();
                    writer.write("# OBR Repository list");
                    writer.newLine();
                    writer.write("# ");
                    writer.newLine();
                    writer.write("obr.repository.url = " + sb.toString());
                    writer.newLine();
                    writer.newLine();
                }
            }
            sys.delete();
            sysTmp.renameTo(sys);
        }
        catch (Exception e) {
            System.err.println("Error while persisting repository list");
        }
    }
}

