/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.util.Dictionary;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.karaf.maven.command.MavenSecuritySupport;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.maven.settings.Proxy;
import org.osgi.service.cm.Configuration;

@Command(scope="maven", name="http-proxy", description="Manage HTTP proxy configuration for Maven remote repositories")
@Service
public class HttpProxyCommand
extends MavenSecuritySupport {
    @Option(name="--add", description="Adds HTTP proxy configuration to Maven settings", required=false, multiValued=false)
    boolean add;
    @Option(name="--change", description="Changes HTTP proxy configuration in Maven settings", required=false, multiValued=false)
    boolean change;
    @Option(name="--remove", description="Removes HTTP proxy configuration from Maven settings", required=false, multiValued=false)
    boolean remove;
    @Option(name="-id", description="Identifier of HTTP proxy", required=true, multiValued=false)
    String id;
    @Option(name="-f", aliases={"--force"}, description="Do not ask for confirmation", required=false, multiValued=false)
    boolean force = false;
    @Option(name="-u", aliases={"--username"}, description="Username for remote repository", required=false, multiValued=false)
    String username;
    @Option(name="-p", aliases={"--password"}, description="Password for remote repository (may be encrypted, see \"maven:password -ep\")", required=false, multiValued=false)
    String password;
    @Option(name="-n", aliases={"--non-proxy-hosts"}, description="Non-proxied hosts (in the format '192.168.*|localhost|...')", required=false, multiValued=false)
    String nonProxyHosts;
    @Argument(description="host:port of HTTP proxy", required=false, multiValued=false)
    String hostPort;

    @Override
    public void doAction(String prefix, Dictionary<String, Object> config) throws Exception {
        boolean hasCredentials;
        if (this.add && (this.change || this.remove) || this.change && this.remove) {
            System.err.println("Please specify only one of --add/--change/--remove");
            return;
        }
        if (this.id == null || "".equals(this.id.trim())) {
            System.err.println("Please specify ID of HTTP proxy");
            return;
        }
        if (this.mavenSettings.getProxies() == null) {
            this.mavenSettings.setProxies(new LinkedList<Proxy>());
        }
        Optional<Proxy> existingProxy = this.mavenSettings.getProxies().stream().filter(p -> this.id.equals(p.getId())).findAny();
        if (this.add) {
            if (this.hostPort == null || "".equals(this.hostPort.trim())) {
                System.err.println("Please specify host:port of new HTTP proxy");
                return;
            }
            if (existingProxy.isPresent()) {
                System.err.printf("HTTP proxy with ID \"%s\" is already configured\n", this.id);
                return;
            }
        } else if (!existingProxy.isPresent()) {
            System.err.printf("Can't find HTTP proxy with ID \"%s\"\n", this.id);
            return;
        }
        boolean hasUsername = this.username != null && !"".equals(this.username.trim());
        boolean hasPassword = this.password != null && !"".equals(this.password.trim());
        boolean bl = hasCredentials = hasUsername && hasPassword;
        if (hasUsername && !hasPassword || !hasUsername && hasPassword) {
            System.err.println("Please specify both username and password");
            return;
        }
        Proxy proxy = null;
        if (this.add) {
            proxy = new Proxy();
            proxy.setId(this.id);
            this.mavenSettings.getProxies().add(proxy);
        } else if (this.change) {
            proxy = existingProxy.get();
        } else {
            List<Proxy> newProxies = this.mavenSettings.getProxies().stream().filter(p -> !this.id.equals(p.getId())).collect(Collectors.toList());
            this.mavenSettings.setProxies(newProxies);
        }
        if (this.add || this.change) {
            proxy.setActive(true);
            proxy.setProtocol("http");
            if (this.nonProxyHosts != null && !"".equals(this.nonProxyHosts.trim())) {
                proxy.setNonProxyHosts(this.nonProxyHosts);
            }
            if (this.hostPort != null && !"".equals(this.hostPort.trim())) {
                if (this.hostPort.contains(":")) {
                    proxy.setHost(this.hostPort.substring(0, this.hostPort.indexOf(58)));
                    proxy.setPort(Integer.parseInt(this.hostPort.substring(this.hostPort.indexOf(58) + 1)));
                } else {
                    proxy.setHost(this.hostPort);
                    proxy.setPort(3128);
                }
            }
            if (hasCredentials) {
                proxy.setUsername(this.username);
                proxy.setPassword(this.password);
            }
        }
        this.updateSettings(prefix, config);
        Configuration cmConfig = this.cm.getConfiguration("org.ops4j.pax.url.mvn");
        cmConfig.update(config);
        if (this.showPasswords) {
            this.session.execute((CharSequence)"maven:http-proxy-list -x");
        } else {
            this.session.execute((CharSequence)"maven:http-proxy-list");
        }
    }
}

