/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.util.Dictionary;
import org.apache.karaf.maven.command.MavenSecuritySupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.apache.maven.settings.Proxy;

@Command(scope="maven", name="http-proxy-list", description="Lists HTTP proxy configurations for Maven remote repositories")
@Service
public class HttpProxyListCommand
extends MavenSecuritySupport {
    @Override
    public void doAction(String prefix, Dictionary<String, Object> config) throws Exception {
        System.out.println();
        if (this.mavenSettings != null && this.mavenSettings.getProxies() != null && this.mavenSettings.getProxies().size() > 0) {
            ShellTable table = new ShellTable();
            table.column("ID");
            table.column("Host");
            table.column("Port");
            table.column("Non-proxy hosts");
            table.column("Username");
            if (this.showPasswords) {
                table.column("Password");
            }
            for (Proxy _p : this.mavenSettings.getProxies()) {
                Row row = table.addRow();
                row.addContent(new Object[]{_p.getId(), _p.getHost(), _p.getPort(), _p.getNonProxyHosts()});
                row.addContent(new Object[]{_p.getUsername() != null ? _p.getUsername() : ""});
                if (!this.showPasswords) continue;
                this.addPasswordInfo(row, this.proxyPasswords, _p.getId(), _p.getPassword());
            }
            table.print(System.out);
        } else {
            System.out.print("No HTTP proxies configured");
            if (this.settings != null && this.settings.value != null) {
                System.out.print(" in " + this.settings.value);
            }
            System.out.println();
        }
        System.out.println();
    }
}

