/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.karaf.maven.command.MavenConfigurationSupport;
import org.apache.karaf.maven.command.RepositoryEditCommandSupport;
import org.apache.karaf.maven.core.MavenRepositoryURL;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.osgi.service.cm.Configuration;

@Command(scope="maven", name="repository-add", description="Adds Maven repository")
@Service
public class RepositoryAddCommand
extends RepositoryEditCommandSupport {
    @Option(name="-idx", description="Index at which new repository is to be inserted (0-based) (defaults to last - repository will be appended)", required=false, multiValued=false)
    int idx = -1;
    @Option(name="-s", aliases={"--snapshots"}, description="Enable SNAPSHOT handling in the repository", required=false, multiValued=false)
    boolean snapshots = false;
    @Option(name="-nr", aliases={"--no-releases"}, description="Disable release handling in this repository", required=false, multiValued=false)
    boolean noReleases = false;
    @Option(name="-up", aliases={"--update-policy"}, description="Update policy for repository (never, daily (default), interval:N, always)", required=false, multiValued=false)
    String updatePolicy = "daily";
    @Option(name="-cp", aliases={"--checksum-policy"}, description="Checksum policy for repository (ignore, warn (default), fail)", required=false, multiValued=false)
    String checksumPolicy = "warn";
    @Option(name="-u", aliases={"--username"}, description="Username for remote repository", required=false, multiValued=false)
    String username;
    @Option(name="-p", aliases={"--password"}, description="Password for remote repository (may be encrypted, see \"maven:password -ep\")", required=false, multiValued=false)
    String password;
    @Argument(description="Repository URI. It may be file:// based, http(s):// based, may use other known protocol or even property placeholders (like ${karaf.base})")
    String uri;

    @Override
    protected void edit(String prefix, Dictionary<String, Object> config, MavenRepositoryURL[] allRepos, MavenRepositoryURL[] pidRepos, MavenRepositoryURL[] settingsRepos) throws Exception {
        boolean hasCredentials;
        if (this.idx > pidRepos.length) {
            System.err.printf("List of %s repositories has %d elements. Can't insert at position %s.\n", this.defaultRepository ? "default" : "remote", pidRepos.length, this.id);
            return;
        }
        Optional<MavenRepositoryURL> first = Arrays.stream(allRepos).filter(repo -> this.id.equals(repo.getId())).findAny();
        if (first.isPresent()) {
            System.err.printf("Repository with ID \"%s\" is already configured for URL %s\n", this.id, first.get().getURL());
            return;
        }
        MavenConfigurationSupport.SourceAnd<String> up = this.updatePolicy(this.updatePolicy);
        if (!up.valid) {
            System.err.println("Unknown value of update policy: \"" + this.updatePolicy + "\"");
            return;
        }
        MavenConfigurationSupport.SourceAnd<String> cp = this.checksumPolicy(this.checksumPolicy);
        if (!cp.valid) {
            System.err.println("Unknown value of checksum policy: \"" + this.checksumPolicy + "\"");
            return;
        }
        MavenConfigurationSupport.SourceAnd<String> urlResolved = this.validateRepositoryURL(this.uri, this.defaultRepository);
        if (!urlResolved.valid) {
            return;
        }
        boolean hasUsername = this.username != null && !"".equals(this.username.trim());
        boolean hasPassword = this.password != null && !"".equals(this.password.trim());
        boolean bl = hasCredentials = hasUsername && hasPassword;
        if (hasUsername && !hasPassword || !hasUsername && hasPassword) {
            System.err.println("Please specify both username and password");
            return;
        }
        if (this.defaultRepository && hasCredentials) {
            System.out.println("User credentials won't be used for default repository");
        }
        if (!this.defaultRepository && hasCredentials) {
            if (!this.updateCredentials(this.force, this.id, this.username, this.password, prefix, config)) {
                return;
            }
            this.updateSettings(prefix, config);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(urlResolved.val());
        sb.append("@id=").append(this.id);
        if (this.snapshots) {
            sb.append("@snapshots");
        }
        if (this.noReleases) {
            sb.append("@noreleases");
        }
        sb.append("@update=").append(this.updatePolicy);
        sb.append("@checksum=").append(this.checksumPolicy);
        MavenRepositoryURL newRepository = new MavenRepositoryURL(sb.toString());
        LinkedList<MavenRepositoryURL> newRepos = new LinkedList<MavenRepositoryURL>(Arrays.asList(pidRepos));
        if (this.idx >= 0) {
            newRepos.add(this.idx, newRepository);
        } else {
            newRepos.add(newRepository);
        }
        this.updatePidRepositories(prefix, config, this.defaultRepository, newRepos, settingsRepos.length > 0);
        Configuration cmConfig = this.cm.getConfiguration("org.ops4j.pax.url.mvn");
        cmConfig.update(config);
        this.success = true;
    }
}

