/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.felix.utils.properties.InterpolationHelper;
import org.apache.karaf.maven.command.MavenConfigurationSupport;
import org.apache.karaf.maven.command.MavenSecuritySupport;
import org.apache.karaf.maven.core.MavenRepositoryURL;
import org.apache.karaf.shell.api.action.Option;
import org.apache.maven.settings.Server;

public abstract class RepositoryEditCommandSupport
extends MavenSecuritySupport {
    @Option(name="-id", description="Identifier of repository", required=true, multiValued=false)
    String id;
    @Option(name="-d", aliases={"--default"}, description="Edit default repository instead of remote one", required=false, multiValued=false)
    boolean defaultRepository = false;
    @Option(name="-f", aliases={"--force"}, description="Do not ask for confirmation", required=false, multiValued=false)
    boolean force = false;
    boolean success = false;

    @Override
    public final void doAction(String prefix, Dictionary<String, Object> config) throws Exception {
        if (this.id == null || "".equals(this.id.trim())) {
            System.err.println("Please specify ID of repository");
            return;
        }
        MavenRepositoryURL[] repositories = this.repositories(config, !this.defaultRepository);
        MavenRepositoryURL[] repositoriesFromPidProperty = (MavenRepositoryURL[])Arrays.stream(repositories).filter(repo -> repo.getFrom() == MavenRepositoryURL.FROM.PID).toArray(MavenRepositoryURL[]::new);
        MavenRepositoryURL[] repositoriesFromSettings = (MavenRepositoryURL[])Arrays.stream(repositories).filter(repo -> repo.getFrom() == MavenRepositoryURL.FROM.SETTINGS).toArray(MavenRepositoryURL[]::new);
        this.edit(prefix, config, repositories, repositoriesFromPidProperty, repositoriesFromSettings);
        if (this.success) {
            if (this.showPasswords) {
                this.session.execute((CharSequence)"maven:repository-list -v -x");
            } else {
                this.session.execute((CharSequence)"maven:repository-list -v");
            }
        }
    }

    protected abstract void edit(String var1, Dictionary<String, Object> var2, MavenRepositoryURL[] var3, MavenRepositoryURL[] var4, MavenRepositoryURL[] var5) throws Exception;

    protected void updatePidRepositories(String prefix, Dictionary<String, Object> config, boolean defaultRepository, List<MavenRepositoryURL> newRepos, boolean hasSettingsRepositories) {
        String newList = newRepos.stream().map(MavenRepositoryURL::asRepositorySpec).collect(Collectors.joining(","));
        if (defaultRepository) {
            config.put(prefix + "defaultRepositories", newList);
        } else {
            if (hasSettingsRepositories) {
                newList = "+" + newList;
            }
            config.put(prefix + "repositories", newList);
        }
    }

    protected boolean updateCredentials(boolean force, String id, String username, String password, String prefix, Dictionary<String, Object> config) throws IOException {
        if (!force && !this.confirm("Maven settings will be updated and org.ops4j.pax.url.mvn.settings property will change. Continue? (y/N) ")) {
            return false;
        }
        Optional<Server> existingServer = this.mavenSettings.getServers().stream().filter(s -> id.equals(s.getId())).findAny();
        Server server = null;
        if (existingServer.isPresent()) {
            server = existingServer.get();
        } else {
            server = new Server();
            server.setId(id);
            this.mavenSettings.getServers().add(server);
        }
        server.setUsername(username);
        server.setPassword(password);
        return true;
    }

    protected MavenConfigurationSupport.SourceAnd<String> validateRepositoryURL(String uri, boolean defaultRepository) throws URISyntaxException, MalformedURLException {
        MavenConfigurationSupport.SourceAnd<String> result = new MavenConfigurationSupport.SourceAnd<String>();
        result.valid = false;
        if (uri == null || "".equals(uri.trim())) {
            System.err.println("Please specify repository location");
            return result;
        }
        String urlResolved = InterpolationHelper.substVars(uri, "uri", null, null, this.context);
        URL url = null;
        try {
            url = new URL(urlResolved);
            urlResolved = url.toString();
            if ("file".equals(url.getProtocol()) && new File(url.toURI()).isDirectory()) {
                System.err.println("Location \"" + urlResolved + "\" is not accessible");
                return result;
            }
        }
        catch (MalformedURLException e) {
            File location = new File(urlResolved);
            if (!location.exists() || !location.isDirectory()) {
                System.err.println("Location \"" + urlResolved + "\" is not accessible");
                return result;
            }
            url = location.toURI().toURL();
            urlResolved = url.toString();
        }
        if (defaultRepository && !"file".equals(url.getProtocol())) {
            System.err.println("Default repositories should be locally accessible (use file:// protocol or normal directory path)");
            return result;
        }
        result.valid = true;
        result.value = urlResolved;
        return result;
    }
}

