/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.karaf.maven.command.RepositoryEditCommandSupport;
import org.apache.karaf.maven.core.MavenRepositoryURL;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.osgi.service.cm.Configuration;

@Command(scope="maven", name="repository-remove", description="Removes Maven repository")
@Service
public class RepositoryRemoveCommand
extends RepositoryEditCommandSupport {
    @Override
    protected void edit(String prefix, Dictionary<String, Object> config, MavenRepositoryURL[] allRepos, MavenRepositoryURL[] pidRepos, MavenRepositoryURL[] settingsRepos) throws Exception {
        Optional<MavenRepositoryURL> first = Arrays.stream(allRepos).filter(repo -> this.id.equals(repo.getId())).findAny();
        if (!first.isPresent()) {
            System.err.printf("Can't find %s repository with ID \"%s\"\n", this.defaultRepository ? "default" : "remote", this.id);
            return;
        }
        if (this.force || this.confirm(String.format("Are you sure to remove repository with ID \"%s\" for URL %s? (y/N) ", this.id, first.get().getURL()))) {
            if (!this.defaultRepository && first.get().getFrom() == MavenRepositoryURL.FROM.SETTINGS) {
                List<Server> newServers = this.mavenSettings.getServers().stream().filter(s -> !this.id.equals(s.getId())).collect(Collectors.toList());
                this.mavenSettings.setServers(newServers);
                for (Profile profile : this.mavenSettings.getProfiles()) {
                    if (!profile.getRepositories().stream().anyMatch(r -> this.id.equals(r.getId()))) continue;
                    List<Repository> newRepos = profile.getRepositories().stream().filter(r -> !this.id.equals(r.getId())).collect(Collectors.toList());
                    profile.setRepositories(newRepos);
                    System.out.printf("Repository with ID \"%s\" was removed from profile \"%s\"\n", this.id, profile.getId());
                    break;
                }
                this.updateSettings(prefix, config);
            } else if (first.get().getFrom() == MavenRepositoryURL.FROM.PID) {
                List<MavenRepositoryURL> newRepos = Arrays.stream(pidRepos).filter(r -> !this.id.equals(r.getId())).collect(Collectors.toList());
                this.updatePidRepositories(prefix, config, this.defaultRepository, newRepos, settingsRepos.length > 0);
                if (this.mavenSettings.getServers().stream().anyMatch(s -> this.id.equals(s.getId()))) {
                    List<Server> newServers = this.mavenSettings.getServers().stream().filter(s -> !this.id.equals(s.getId())).collect(Collectors.toList());
                    this.mavenSettings.setServers(newServers);
                    this.updateSettings(prefix, config);
                }
            }
            Configuration cmConfig = this.cm.getConfiguration("org.ops4j.pax.url.mvn");
            cmConfig.update(config);
            this.success = true;
        }
    }
}

