/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.util.Dictionary;
import org.apache.karaf.maven.command.MavenConfigurationSupport;
import org.apache.karaf.maven.command.MavenSecuritySupport;
import org.apache.karaf.maven.core.MavenRepositoryURL;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.Row;
import org.apache.karaf.shell.support.table.ShellTable;
import org.apache.maven.settings.Proxy;

@Command(scope="maven", name="summary", description="Maven configuration summary.")
@Service
public class SummaryCommand
extends MavenSecuritySupport {
    @Option(name="-p", aliases={"--property-ids"}, description="Use PID property identifiers instead of their names", required=false, multiValued=false)
    boolean propertyIds;
    @Option(name="-s", aliases={"--source"}, description="Adds information about where the value is configured", required=false, multiValued=false)
    boolean source;
    @Option(name="-d", aliases={"--description"}, description="Adds description of Maven configuration options", required=false, multiValued=false)
    boolean description;

    @Override
    protected void doAction(String prefix, Dictionary<String, Object> config) throws Exception {
        ShellTable table = new ShellTable();
        table.column("Option");
        table.column("Value");
        if (this.source) {
            table.column("Source");
        }
        if (this.description) {
            table.column("Description");
        }
        this.addRow(table, this.propertyIds ? "localRepository" : "Local repository", this.localRepository, "Maven repository to store artifacts resolved in *remote repositories*");
        this.addRow(table, this.propertyIds ? "settings" : "Settings file", this.settings, "Settings file that may contain configuration of additional repositories, http proxies and mirrors");
        this.addRow(table, this.propertyIds ? "security" : "Security settings file", this.securitySettings, "Settings file that contain (or relocates to) master Maven password");
        if (this.showPasswords) {
            this.addRow(table, this.propertyIds ? "<master>" : "Master password", new MavenConfigurationSupport.SourceAnd<String>(this.securitySettings.source, this.masterPassword), "Master password used to decrypt proxy and server passwords");
        }
        MavenConfigurationSupport.SourceAnd<String> updatePolicy = this.updatePolicy((String)config.get(prefix + "globalUpdatePolicy"));
        this.addRow(table, this.propertyIds ? "globalUpdatePolicy" : "Global update policy", updatePolicy, "Overrides update policy specified at repository level (if specified)");
        MavenConfigurationSupport.SourceAnd<String> checksumPolicy = this.checksumPolicy((String)config.get(prefix + "globalChecksumPolicy"));
        this.addRow(table, this.propertyIds ? "globalChecksumPolicy" : "Global checksum policy", checksumPolicy, "Checksum policy for all repositories");
        String updateReleasesProperty = (String)config.get(prefix + "updateReleases");
        boolean updateReleases = false;
        String sourceInfo = String.format("Explicit %s PID configuration (%s)", "org.ops4j.pax.url.mvn", prefix + "updateReleases");
        if (updateReleasesProperty == null) {
            sourceInfo = "Default \"false\"";
        } else {
            updateReleases = "true".equals(updateReleasesProperty);
        }
        this.addRow(table, this.propertyIds ? "updateReleases" : "Update releases", new MavenConfigurationSupport.SourceAnd<Boolean>(sourceInfo, updateReleases), "Whether to download non-SNAPSHOT artifacts according to update policy");
        String requireConfigAdminProperty = this.context.getProperty(prefix + "requireConfigAdminConfig");
        boolean requireConfigAdmin = requireConfigAdminProperty != null;
        sourceInfo = "Default \"false\"";
        if (requireConfigAdmin) {
            sourceInfo = "BundleContext property (" + prefix + "requireConfigAdminConfig" + ")";
        }
        this.addRow(table, this.propertyIds ? "requireConfigAdminConfig" : "Require Config Admin", new MavenConfigurationSupport.SourceAnd<Boolean>(sourceInfo, requireConfigAdmin), "Whether MavenResolver service is registered ONLY with proper org.ops4j.pax.url.mvn PID configuration");
        String useFallbackRepositoriesProperty = (String)config.get(prefix + "useFallbackRepositories");
        boolean useFallbackRepositories = Boolean.parseBoolean(useFallbackRepositoriesProperty);
        sourceInfo = "Default \"false\"";
        if (useFallbackRepositoriesProperty != null) {
            sourceInfo = String.format("Explicit %s PID configuration (%s)", "org.ops4j.pax.url.mvn", prefix + "useFallbackRepositories");
        }
        this.addRow(table, this.propertyIds ? "useFallbackRepositories" : "Use fallback repository", new MavenConfigurationSupport.SourceAnd<Boolean>(sourceInfo, useFallbackRepositories), "Whether Maven Central is used as implicit, additional remote repository");
        String offlineProperty = (String)config.get(prefix + "offline");
        boolean offline = Boolean.parseBoolean(offlineProperty);
        sourceInfo = "Default \"false\"";
        if (offlineProperty != null) {
            sourceInfo = String.format("Explicit %s PID configuration (%s)", "org.ops4j.pax.url.mvn", prefix + "offline");
        }
        this.addRow(table, this.propertyIds ? "offline" : "Offline mode", new MavenConfigurationSupport.SourceAnd<Boolean>(sourceInfo, offline), "Disables access to external remote repositories (file:// based ones are still used)");
        String certificateCheckProperty = (String)config.get(prefix + "certificateCheck");
        boolean certificateCheck = Boolean.parseBoolean(certificateCheckProperty);
        sourceInfo = "Default \"false\"";
        if (certificateCheckProperty != null) {
            sourceInfo = String.format("Explicit %s PID configuration (%s)", "org.ops4j.pax.url.mvn", prefix + "certificateCheck");
        }
        this.addRow(table, this.propertyIds ? "certificateCheck" : "SSL/TLS certificate check", new MavenConfigurationSupport.SourceAnd<Boolean>(sourceInfo, certificateCheck), "Turns on server certificate validation for HTTPS remote repositories");
        MavenRepositoryURL[] remoteRepositories = this.repositories(config, true);
        boolean first = true;
        for (MavenRepositoryURL url : remoteRepositories) {
            this.addRow(table, first ? (this.propertyIds ? "repositories" : "Remote repositories") : "", new MavenConfigurationSupport.SourceAnd<String>(url.getFrom().getSource(), url.getURL().toString()), first ? "Remote repositories where artifacts are being resolved if not found locally" : "");
            first = false;
        }
        MavenRepositoryURL[] defaultRepositories = this.repositories(config, false);
        first = true;
        for (MavenRepositoryURL url : defaultRepositories) {
            this.addRow(table, first ? (this.propertyIds ? "defaultRepositories" : "Default repositories") : "", new MavenConfigurationSupport.SourceAnd<String>(url.getFrom().getSource(), url.getURL().toString()), first ? "Repositories where artifacts are looked up before trying remote resolution" : "");
            first = false;
        }
        if (this.mavenSettings != null && this.mavenSettings.getProxies() != null) {
            first = true;
            for (Proxy proxy : this.mavenSettings.getProxies()) {
                String value = String.format("%s:%s", proxy.getHost(), proxy.getPort());
                this.addRow(table, first ? (this.propertyIds ? "<proxies>" : "HTTP proxies") : "", new MavenConfigurationSupport.SourceAnd<String>(MavenRepositoryURL.FROM.SETTINGS.getSource(), value), first ? "Maven HTTP proxies" : "");
                first = false;
            }
        }
        System.out.println();
        table.print(System.out);
        System.out.println();
    }

    private <T> void addRow(ShellTable table, String label, MavenConfigurationSupport.SourceAnd<T> value, String descriptionText) {
        Row row = table.addRow();
        row.addContent(new Object[]{label, value.val()});
        if (this.source) {
            row.addContent(new Object[]{value.source});
        }
        if (this.description) {
            row.addContent(new Object[]{descriptionText});
        }
    }
}

