/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRepositoryURL {
    private static final Logger LOG = LoggerFactory.getLogger(MavenRepositoryURL.class);
    private final String m_id;
    private URL m_repositoryURL;
    private final File m_file;
    private boolean m_snapshotsEnabled;
    private boolean m_releasesEnabled;
    private String m_releasesUpdatePolicy;
    private String m_snapshotsUpdatePolicy;
    private String m_releasesChecksumPolicy;
    private String m_snapshotsChecksumPolicy;
    private final boolean m_multi;
    private final FROM m_from;

    public MavenRepositoryURL(String repositorySpec) throws MalformedURLException {
        String[] segments = repositorySpec.split("@");
        StringBuilder urlBuilder = new StringBuilder();
        boolean snapshotEnabled = false;
        boolean releasesEnabled = true;
        boolean multi = false;
        String name = null;
        String update = null;
        String updateReleases = null;
        String updateSnapshots = null;
        String checksum = null;
        String checksumReleases = null;
        String checksumSnapshots = null;
        FROM from = null;
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i].trim();
            if (segment.equalsIgnoreCase("snapshots")) {
                snapshotEnabled = true;
                continue;
            }
            if (segment.equalsIgnoreCase("noreleases")) {
                releasesEnabled = false;
                continue;
            }
            if (segment.equalsIgnoreCase("multi")) {
                multi = true;
                continue;
            }
            if (segment.startsWith("id=")) {
                try {
                    name = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("releasesUpdate=")) {
                try {
                    updateReleases = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("snapshotsUpdate=")) {
                try {
                    updateSnapshots = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("update=")) {
                try {
                    update = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("releasesChecksum=")) {
                try {
                    checksumReleases = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("snapshotsChecksum=")) {
                try {
                    checksumSnapshots = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("checksum=")) {
                try {
                    checksum = segments[i].split("=")[1].trim();
                }
                catch (Exception e) {
                    LOG.warn("Problem with segment " + segments[i] + " in " + repositorySpec);
                }
                continue;
            }
            if (segment.startsWith("_from=")) {
                try {
                    from = FROM.valueOf(segments[i].split("=")[1].trim());
                }
                catch (Exception e) {}
                continue;
            }
            if (i > 0) {
                urlBuilder.append("@");
            }
            urlBuilder.append(segments[i]);
        }
        String spec = this.buildSpec(urlBuilder);
        this.m_repositoryURL = new URL(spec);
        this.m_snapshotsEnabled = snapshotEnabled;
        this.m_releasesEnabled = releasesEnabled;
        this.m_multi = multi;
        if (name == null) {
            String warn = "Repository spec " + spec + " does not contain an identifier. This is deprecated & discouraged & just evil.";
            LOG.warn(warn);
            name = "repo_" + spec.hashCode();
        }
        this.m_id = name;
        this.m_releasesUpdatePolicy = updateReleases != null ? updateReleases : update;
        this.m_snapshotsUpdatePolicy = updateSnapshots != null ? updateSnapshots : update;
        this.m_releasesChecksumPolicy = checksumReleases != null ? checksumReleases : checksum;
        this.m_snapshotsChecksumPolicy = checksumSnapshots != null ? checksumSnapshots : checksum;
        FROM fROM = this.m_from = from != null ? from : FROM.PID;
        if (this.m_repositoryURL.getProtocol().equals("file")) {
            try {
                spec = spec.replaceAll("\\\\", "/");
                spec = spec.replaceAll(" ", "%20");
                URI uri = new URI(spec);
                String path = uri.getPath();
                if (path == null) {
                    path = uri.getSchemeSpecificPart();
                }
                this.m_file = new File(path);
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
        } else {
            this.m_file = null;
        }
    }

    private String buildSpec(StringBuilder urlBuilder) {
        String spec = urlBuilder.toString().trim();
        if (!spec.endsWith("\\") && !spec.endsWith("/")) {
            spec = spec + "/";
        }
        return spec;
    }

    public String getId() {
        return this.m_id;
    }

    public URL getURL() {
        return this.m_repositoryURL;
    }

    public void setURL(URL url) {
        this.m_repositoryURL = url;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isReleasesEnabled() {
        return this.m_releasesEnabled;
    }

    public void setReleasesEnabled(boolean enabled) {
        this.m_releasesEnabled = enabled;
    }

    public boolean isSnapshotsEnabled() {
        return this.m_snapshotsEnabled;
    }

    public void setSnapshotsEnabled(boolean enabled) {
        this.m_snapshotsEnabled = enabled;
    }

    public String getReleasesUpdatePolicy() {
        return this.m_releasesUpdatePolicy;
    }

    public String getSnapshotsUpdatePolicy() {
        return this.m_snapshotsUpdatePolicy;
    }

    public String getReleasesChecksumPolicy() {
        return this.m_releasesChecksumPolicy;
    }

    public String getSnapshotsChecksumPolicy() {
        return this.m_snapshotsChecksumPolicy;
    }

    public void setReleasesUpdatePolicy(String policy) {
        this.m_releasesUpdatePolicy = policy;
    }

    public void setSnapshotsUpdatePolicy(String policy) {
        this.m_snapshotsUpdatePolicy = policy;
    }

    public void setReleasesChecksumPolicy(String policy) {
        this.m_releasesChecksumPolicy = policy;
    }

    public void setSnapshotsChecksumPolicy(String policy) {
        this.m_snapshotsChecksumPolicy = policy;
    }

    public FROM getFrom() {
        return this.m_from;
    }

    public boolean isMulti() {
        return this.m_multi;
    }

    public boolean isFileRepository() {
        return this.m_file != null;
    }

    public String toString() {
        return this.m_repositoryURL.toString() + ",releases=" + this.m_releasesEnabled + ",snapshots=" + this.m_snapshotsEnabled;
    }

    public String asRepositorySpec() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_repositoryURL.toString());
        if (this.m_id != null) {
            sb.append("@id=" + this.m_id);
        }
        if (!this.m_releasesEnabled) {
            sb.append("@noreleases");
        }
        if (this.m_snapshotsEnabled) {
            sb.append("@snapshots");
        }
        if (this.m_releasesEnabled && !this.m_snapshotsEnabled) {
            if (this.m_releasesUpdatePolicy != null) {
                sb.append("@releasesUpdate=" + this.m_releasesUpdatePolicy);
            }
            if (this.m_releasesChecksumPolicy != null) {
                sb.append("@releasesChecksum=" + this.m_releasesChecksumPolicy);
            }
        }
        if (this.m_snapshotsEnabled && !this.m_releasesEnabled) {
            if (this.m_snapshotsUpdatePolicy != null) {
                sb.append("@snapshotsUpdate=" + this.m_snapshotsUpdatePolicy);
            }
            if (this.m_snapshotsChecksumPolicy != null) {
                sb.append("@snapshotsChecksum=" + this.m_snapshotsChecksumPolicy);
            }
        }
        if (this.m_snapshotsEnabled && this.m_releasesEnabled) {
            if (this.m_releasesUpdatePolicy != null && Objects.equals(this.m_releasesUpdatePolicy, this.m_snapshotsUpdatePolicy)) {
                sb.append("@update=" + this.m_releasesUpdatePolicy);
            }
            if (this.m_releasesChecksumPolicy != null && Objects.equals(this.m_releasesChecksumPolicy, this.m_snapshotsChecksumPolicy)) {
                sb.append("@checksum=" + this.m_releasesChecksumPolicy);
            }
        }
        return sb.toString();
    }

    public static enum FROM {
        PID("PID configuration"),
        SETTINGS("Maven XML settings"),
        FALLBACK("Fallback repository");

        private String source;

        private FROM(String source) {
            this.source = source;
        }

        public String getSource() {
            return this.source;
        }
    }
}

