/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public final class EffectiveAugmentationSchema
implements AugmentationSchemaNode {
    private final AugmentationSchemaNode delegate;
    private final ImmutableSet<DataSchemaNode> realChildSchemas;
    private final ImmutableMap<QName, DataSchemaNode> mappedChildSchemas;

    public EffectiveAugmentationSchema(AugmentationSchemaNode augmentSchema, Set<DataSchemaNode> realChildSchemas) {
        this.delegate = Objects.requireNonNull(augmentSchema);
        this.realChildSchemas = ImmutableSet.copyOf(realChildSchemas);
        HashMap<QName, DataSchemaNode> m = new HashMap<QName, DataSchemaNode>(realChildSchemas.size());
        for (DataSchemaNode realChildSchema : realChildSchemas) {
            m.put(realChildSchema.getQName(), realChildSchema);
        }
        this.mappedChildSchemas = ImmutableMap.copyOf(m);
    }

    public static AugmentationSchemaNode create(AugmentationSchemaNode schema, DataNodeContainer parent) {
        HashSet<DataSchemaNode> children = new HashSet<DataSchemaNode>();
        for (DataSchemaNode augNode : schema.getChildNodes()) {
            children.add(parent.getDataChildByName(augNode.getQName()));
        }
        return new EffectiveAugmentationSchema(schema, children);
    }

    public Optional<RevisionAwareXPath> getWhenCondition() {
        return this.delegate.getWhenCondition();
    }

    public Optional<String> getDescription() {
        return this.delegate.getDescription();
    }

    public Optional<String> getReference() {
        return this.delegate.getReference();
    }

    public Status getStatus() {
        return this.delegate.getStatus();
    }

    public SchemaPath getTargetPath() {
        return this.delegate.getTargetPath();
    }

    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.delegate.getUnknownSchemaNodes();
    }

    public Set<TypeDefinition<?>> getTypeDefinitions() {
        return this.delegate.getTypeDefinitions();
    }

    public Set<DataSchemaNode> getChildNodes() {
        return this.realChildSchemas;
    }

    public Set<GroupingDefinition> getGroupings() {
        return this.delegate.getGroupings();
    }

    public Optional<DataSchemaNode> findDataChildByName(QName name) {
        return Optional.ofNullable(this.mappedChildSchemas.get((Object)Objects.requireNonNull(name)));
    }

    public Set<UsesNode> getUses() {
        return this.delegate.getUses();
    }

    public Optional<AugmentationSchemaNode> getOriginalDefinition() {
        return this.delegate.getOriginalDefinition();
    }

    public Set<ActionDefinition> getActions() {
        return this.delegate.getActions();
    }

    public Set<NotificationDefinition> getNotifications() {
        return this.delegate.getNotifications();
    }
}

