/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.yang.common.BiMapYangNamespaceContext;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangNamespaceContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextProvider;

@Beta
public final class ModuleNameNamespaceContext
implements YangNamespaceContext,
SchemaContextProvider {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Handled through writeReplace()")
    private final SchemaContext schemaContext;

    public ModuleNameNamespaceContext(SchemaContext schemaContext) {
        this.schemaContext = Objects.requireNonNull(schemaContext);
    }

    public BiMapYangNamespaceContext toBiMap() {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        for (String name : this.schemaContext.getModules().stream().map(Module::getName).collect(Collectors.toSet())) {
            builder.put((Object)name, (Object)this.findNamespaceForPrefix(name).get());
        }
        return new BiMapYangNamespaceContext((BiMap)builder.build());
    }

    public SchemaContext getSchemaContext() {
        return this.schemaContext;
    }

    public Optional<QNameModule> findNamespaceForPrefix(String prefix) {
        return this.schemaContext.findModules(prefix).stream().findFirst().map(Module::getQNameModule);
    }

    public Optional<String> findPrefixForNamespace(QNameModule namespace) {
        return this.schemaContext.findModule(namespace).map(Module::getName);
    }

    private Object writeReplace() {
        return this.toBiMap();
    }
}

