/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNode;
import org.opendaylight.yangtools.rfc7952.model.api.AnnotationSchemaNodeAwareSchemaContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.AbstractSchemaContext;
import org.opendaylight.yangtools.yang.model.util.ModuleDependencySort;

@Beta
public class SimpleSchemaContext
extends AbstractSchemaContext
implements AnnotationSchemaNodeAwareSchemaContext {
    private final ImmutableSetMultimap<URI, Module> namespaceToModules;
    private final ImmutableSetMultimap<String, Module> nameToModules;
    private final ImmutableMap<QNameModule, Module> moduleMap;
    private final ImmutableSet<Module> modules;
    private final ImmutableMap<QName, AnnotationSchemaNode> annotations;

    protected SimpleSchemaContext(Set<Module> modules) {
        ArrayList<Module> sortedModules = new ArrayList<Module>(ModuleDependencySort.sort(modules));
        sortedModules.sort(NAME_REVISION_COMPARATOR);
        this.modules = ImmutableSet.copyOf(sortedModules);
        SetMultimap nsMap = Multimaps.newSetMultimap(new TreeMap(), AbstractSchemaContext::createModuleSet);
        SetMultimap nameMap = Multimaps.newSetMultimap(new TreeMap(), AbstractSchemaContext::createModuleSet);
        ImmutableMap.Builder moduleMapBuilder = ImmutableMap.builder();
        for (Module m : modules) {
            nameMap.put((Object)m.getName(), (Object)m);
            nsMap.put((Object)m.getNamespace(), (Object)m);
            moduleMapBuilder.put((Object)m.getQNameModule(), (Object)m);
        }
        this.namespaceToModules = ImmutableSetMultimap.copyOf((Multimap)nsMap);
        this.nameToModules = ImmutableSetMultimap.copyOf((Multimap)nameMap);
        this.moduleMap = moduleMapBuilder.build();
        this.annotations = ImmutableMap.copyOf((Map)AnnotationSchemaNode.findAll((SchemaContext)this));
    }

    public static SimpleSchemaContext forModules(Set<Module> modules) {
        return new SimpleSchemaContext(modules);
    }

    public final Set<Module> getModules() {
        return this.modules;
    }

    public final Optional<AnnotationSchemaNode> findAnnotation(QName qname) {
        return Optional.ofNullable(this.annotations.get((Object)Objects.requireNonNull(qname)));
    }

    @Override
    protected Map<QNameModule, Module> getModuleMap() {
        return this.moduleMap;
    }

    @Override
    protected final SetMultimap<URI, Module> getNamespaceToModules() {
        return this.namespaceToModules;
    }

    @Override
    protected final SetMultimap<String, Module> getNameToModules() {
        return this.nameToModules;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("modules", this.modules);
    }
}

