/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.collect.ImmutableMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.AbstractRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.BaseBitsType;
import org.opendaylight.yangtools.yang.model.util.type.InvalidBitDefinitionException;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedBitsType;

public final class BitsTypeBuilder
extends AbstractRestrictedTypeBuilder<BitsTypeDefinition> {
    private final ImmutableMap.Builder<String, BitsTypeDefinition.Bit> builder = ImmutableMap.builder();

    BitsTypeBuilder(SchemaPath path) {
        super(null, path);
    }

    BitsTypeBuilder(BitsTypeDefinition baseType, SchemaPath path) {
        super(baseType, path);
    }

    public BitsTypeBuilder addBit(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BitsTypeDefinition.Bit item) {
        if (this.getBaseType() != null) {
            this.validateRestrictedBit(item);
        }
        this.builder.put((Object)item.getName(), (Object)item);
        this.touch();
        return this;
    }

    private void validateRestrictedBit(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull BitsTypeDefinition.Bit item) {
        boolean isASubsetOfBaseBits = false;
        for (BitsTypeDefinition.Bit baseTypeBit : ((BitsTypeDefinition)this.getBaseType()).getBits()) {
            if (!item.getName().equals(baseTypeBit.getName())) continue;
            if (item.getPosition() != baseTypeBit.getPosition()) {
                throw new InvalidBitDefinitionException(item, "Position of bit '%s' must be the same as the position of corresponding bit in the base bits type %s.", item.getName(), ((BitsTypeDefinition)this.getBaseType()).getQName());
            }
            isASubsetOfBaseBits = true;
            break;
        }
        if (!isASubsetOfBaseBits) {
            throw new InvalidBitDefinitionException(item, "Bit '%s' is not a subset of its base bits type %s.", item.getName(), ((BitsTypeDefinition)this.getBaseType()).getQName());
        }
    }

    @Override
    public BitsTypeDefinition buildType() {
        ImmutableMap map = this.builder.build();
        TreeMap<Long, BitsTypeDefinition.Bit> positionMap = new TreeMap<Long, BitsTypeDefinition.Bit>();
        for (BitsTypeDefinition.Bit b : map.values()) {
            BitsTypeDefinition.Bit conflict = positionMap.put(b.getPosition(), b);
            if (conflict == null) continue;
            throw new InvalidBitDefinitionException(b, "Bit %s conflicts on position with bit ", conflict);
        }
        return this.getBaseType() == null ? new BaseBitsType(this.getPath(), this.getUnknownSchemaNodes(), positionMap.values()) : new RestrictedBitsType((BitsTypeDefinition)this.getBaseType(), this.getPath(), this.getUnknownSchemaNodes(), positionMap.values());
    }
}

