/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.annotations.Beta;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.DerivedBinaryType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedBitsType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedBooleanType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedDecimalType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedEmptyType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedEnumerationType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedIdentityrefType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedInstanceIdentifierType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedInt16Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedInt32Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedInt64Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedInt8Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedLeafrefType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedStringType;
import org.opendaylight.yangtools.yang.model.util.type.DerivedUint16Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedUint32Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedUint64Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedUint8Type;
import org.opendaylight.yangtools.yang.model.util.type.DerivedUnionType;

@Beta
@NonNullByDefault
public final class ConcreteTypes {
    private ConcreteTypes() {
        throw new UnsupportedOperationException();
    }

    public static ConcreteTypeBuilder<?> concreteTypeBuilder(TypeDefinition<?> baseType, SchemaPath path) {
        if (baseType instanceof BinaryTypeDefinition) {
            return ConcreteTypes.concreteBinaryBuilder((BinaryTypeDefinition)baseType, path);
        }
        if (baseType instanceof BitsTypeDefinition) {
            return ConcreteTypes.concreteBitsBuilder((BitsTypeDefinition)baseType, path);
        }
        if (baseType instanceof BooleanTypeDefinition) {
            return ConcreteTypes.concreteBooleanBuilder((BooleanTypeDefinition)baseType, path);
        }
        if (baseType instanceof DecimalTypeDefinition) {
            return ConcreteTypes.concreteDecimalBuilder((DecimalTypeDefinition)baseType, path);
        }
        if (baseType instanceof EmptyTypeDefinition) {
            return ConcreteTypes.concreteEmptyBuilder((EmptyTypeDefinition)baseType, path);
        }
        if (baseType instanceof EnumTypeDefinition) {
            return ConcreteTypes.concreteEnumerationBuilder((EnumTypeDefinition)baseType, path);
        }
        if (baseType instanceof IdentityrefTypeDefinition) {
            return ConcreteTypes.concreteIdentityrefBuilder((IdentityrefTypeDefinition)baseType, path);
        }
        if (baseType instanceof InstanceIdentifierTypeDefinition) {
            return ConcreteTypes.concreteInstanceIdentifierBuilder((InstanceIdentifierTypeDefinition)baseType, path);
        }
        if (baseType instanceof Int8TypeDefinition) {
            return ConcreteTypes.concreteInt8Builder((Int8TypeDefinition)baseType, path);
        }
        if (baseType instanceof Int16TypeDefinition) {
            return ConcreteTypes.concreteInt16Builder((Int16TypeDefinition)baseType, path);
        }
        if (baseType instanceof Int32TypeDefinition) {
            return ConcreteTypes.concreteInt32Builder((Int32TypeDefinition)baseType, path);
        }
        if (baseType instanceof Int64TypeDefinition) {
            return ConcreteTypes.concreteInt64Builder((Int64TypeDefinition)baseType, path);
        }
        if (baseType instanceof LeafrefTypeDefinition) {
            return ConcreteTypes.concreteLeafrefBuilder((LeafrefTypeDefinition)baseType, path);
        }
        if (baseType instanceof StringTypeDefinition) {
            return ConcreteTypes.concreteStringBuilder((StringTypeDefinition)baseType, path);
        }
        if (baseType instanceof UnionTypeDefinition) {
            return ConcreteTypes.concreteUnionBuilder((UnionTypeDefinition)baseType, path);
        }
        if (baseType instanceof Uint8TypeDefinition) {
            return ConcreteTypes.concreteUint8Builder((Uint8TypeDefinition)baseType, path);
        }
        if (baseType instanceof Uint16TypeDefinition) {
            return ConcreteTypes.concreteUint16Builder((Uint16TypeDefinition)baseType, path);
        }
        if (baseType instanceof Uint32TypeDefinition) {
            return ConcreteTypes.concreteUint32Builder((Uint32TypeDefinition)baseType, path);
        }
        if (baseType instanceof Uint64TypeDefinition) {
            return ConcreteTypes.concreteUint64Builder((Uint64TypeDefinition)baseType, path);
        }
        throw new IllegalArgumentException("Unhandled type definition class " + baseType.getClass());
    }

    private static ConcreteTypeBuilder<BinaryTypeDefinition> concreteBinaryBuilder(BinaryTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<BinaryTypeDefinition>(baseType, path){

            @Override
            public BinaryTypeDefinition buildType() {
                return new DerivedBinaryType((BinaryTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<BitsTypeDefinition> concreteBitsBuilder(BitsTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<BitsTypeDefinition>(baseType, path){

            @Override
            public BitsTypeDefinition buildType() {
                return new DerivedBitsType((BitsTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<BooleanTypeDefinition> concreteBooleanBuilder(BooleanTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<BooleanTypeDefinition>(baseType, path){

            @Override
            public BooleanTypeDefinition buildType() {
                return new DerivedBooleanType((BooleanTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<DecimalTypeDefinition> concreteDecimalBuilder(DecimalTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<DecimalTypeDefinition>(baseType, path){

            @Override
            public DecimalTypeDefinition buildType() {
                return new DerivedDecimalType((DecimalTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<EmptyTypeDefinition> concreteEmptyBuilder(EmptyTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<EmptyTypeDefinition>(baseType, path){

            @Override
            public EmptyTypeDefinition buildType() {
                return new DerivedEmptyType((EmptyTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<EnumTypeDefinition> concreteEnumerationBuilder(EnumTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<EnumTypeDefinition>(baseType, path){

            @Override
            public EnumTypeDefinition buildType() {
                return new DerivedEnumerationType((EnumTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<IdentityrefTypeDefinition> concreteIdentityrefBuilder(IdentityrefTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<IdentityrefTypeDefinition>(baseType, path){

            @Override
            public IdentityrefTypeDefinition buildType() {
                return new DerivedIdentityrefType((IdentityrefTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<InstanceIdentifierTypeDefinition> concreteInstanceIdentifierBuilder(final InstanceIdentifierTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<InstanceIdentifierTypeDefinition>(baseType, path){

            @Override
            public InstanceIdentifierTypeDefinition buildType() {
                return new DerivedInstanceIdentifierType((InstanceIdentifierTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes(), baseType.requireInstance());
            }
        };
    }

    private static ConcreteTypeBuilder<Int8TypeDefinition> concreteInt8Builder(Int8TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Int8TypeDefinition>(baseType, path){

            @Override
            public Int8TypeDefinition buildType() {
                return new DerivedInt8Type((Int8TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int16TypeDefinition> concreteInt16Builder(Int16TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Int16TypeDefinition>(baseType, path){

            @Override
            public Int16TypeDefinition buildType() {
                return new DerivedInt16Type((Int16TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int32TypeDefinition> concreteInt32Builder(Int32TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Int32TypeDefinition>(baseType, path){

            @Override
            public Int32TypeDefinition buildType() {
                return new DerivedInt32Type((Int32TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int64TypeDefinition> concreteInt64Builder(Int64TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Int64TypeDefinition>(baseType, path){

            @Override
            public Int64TypeDefinition buildType() {
                return new DerivedInt64Type((Int64TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<LeafrefTypeDefinition> concreteLeafrefBuilder(LeafrefTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<LeafrefTypeDefinition>(baseType, path){

            @Override
            public LeafrefTypeDefinition buildType() {
                return new DerivedLeafrefType((LeafrefTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<StringTypeDefinition> concreteStringBuilder(StringTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<StringTypeDefinition>(baseType, path){

            @Override
            public StringTypeDefinition buildType() {
                return new DerivedStringType((StringTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<UnionTypeDefinition> concreteUnionBuilder(UnionTypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<UnionTypeDefinition>(baseType, path){

            @Override
            public DerivedUnionType buildType() {
                return new DerivedUnionType((UnionTypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint8TypeDefinition> concreteUint8Builder(Uint8TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Uint8TypeDefinition>(baseType, path){

            @Override
            public Uint8TypeDefinition buildType() {
                return new DerivedUint8Type((Uint8TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint16TypeDefinition> concreteUint16Builder(Uint16TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Uint16TypeDefinition>(baseType, path){

            @Override
            public Uint16TypeDefinition buildType() {
                return new DerivedUint16Type((Uint16TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint32TypeDefinition> concreteUint32Builder(Uint32TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Uint32TypeDefinition>(baseType, path){

            @Override
            public Uint32TypeDefinition buildType() {
                return new DerivedUint32Type((Uint32TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint64TypeDefinition> concreteUint64Builder(Uint64TypeDefinition baseType, SchemaPath path) {
        return new ConcreteTypeBuilder<Uint64TypeDefinition>(baseType, path){

            @Override
            public Uint64TypeDefinition buildType() {
                return new DerivedUint64Type((Uint64TypeDefinition)this.getBaseType(), this.getPath(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }
}

