/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.EnumPairImpl;

@Beta
public final class EnumPairBuilder
implements Builder<EnumTypeDefinition.EnumPair>,
Mutable {
    private final String name;
    private final Integer value;
    private ImmutableList<UnknownSchemaNode> unknownSchemaNodes = ImmutableList.of();
    private Status status = Status.CURRENT;
    private String description;
    private String reference;

    private EnumPairBuilder(String name, Integer value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
    }

    public static EnumPairBuilder create(String name, Integer value) {
        return new EnumPairBuilder(name, value);
    }

    public EnumPairBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public EnumPairBuilder setReference(String reference) {
        this.reference = reference;
        return this;
    }

    public EnumPairBuilder setStatus(Status status) {
        this.status = Objects.requireNonNull(status);
        return this;
    }

    public EnumPairBuilder setUnknownSchemaNodes(Collection<UnknownSchemaNode> unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf(unknownSchemaNodes);
        return this;
    }

    public EnumPairBuilder setUnknownSchemaNodes(UnknownSchemaNode ... unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf((Object[])unknownSchemaNodes);
        return this;
    }

    public EnumTypeDefinition.EnumPair build() {
        return new EnumPairImpl(this.name, this.value, this.description, this.reference, this.status, this.unknownSchemaNodes);
    }
}

