/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public abstract class TypeBuilder<T extends TypeDefinition<T>>
implements Builder<T> {
    private final ImmutableList.Builder<UnknownSchemaNode> unknownSchemaNodes = ImmutableList.builder();
    private final @NonNull SchemaPath path;
    private final @Nullable T baseType;

    TypeBuilder(@Nullable T baseType, SchemaPath path) {
        this.path = Objects.requireNonNull(path);
        this.baseType = baseType;
    }

    final @Nullable T getBaseType() {
        return this.baseType;
    }

    final @NonNull SchemaPath getPath() {
        return this.path;
    }

    final @NonNull List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes.build();
    }

    public final void addUnknownSchemaNode(@NonNull UnknownSchemaNode node) {
        this.unknownSchemaNodes.add((Object)node);
    }
}

