/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.spi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.opendaylight.jsonrpc.bus.api.BusSession;
import org.opendaylight.jsonrpc.bus.api.BusSessionFactory;
import org.opendaylight.jsonrpc.bus.spi.EventLoopConfiguration;
import org.opendaylight.jsonrpc.bus.spi.EventLoopGroupProvider;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class AbstractBusSessionFactory
implements BusSessionFactory {
    protected final String name;
    protected final ServerBootstrap serverBootstrap;
    protected final Bootstrap clientBootstrap;
    protected final EventExecutorGroup handlerExecutor;
    protected final Set<WeakReference<BusSession>> sessions = ConcurrentHashMap.newKeySet();

    public AbstractBusSessionFactory(String name) {
        this(name, EventLoopGroupProvider.config());
    }

    public AbstractBusSessionFactory(String name, EventLoopConfiguration config) {
        this.name = name;
        this.serverBootstrap = ((ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class)).group(config.bossGroup(), config.workerGroup());
        this.clientBootstrap = (Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(config.workerGroup());
        this.handlerExecutor = config.handlerGroup();
    }

    public String name() {
        return this.name;
    }

    protected void addSession(BusSession session) {
        this.sessions.add(new WeakReference<BusSession>(session));
    }

    public void close() {
        this.sessions.stream().filter(sessRef -> sessRef.get() != null).forEach(sess -> ((BusSession)sess.get()).close());
    }

    protected static URI createUriUnchecked(String uriStr) {
        try {
            return new URI(uriStr);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid URI : %s", uriStr), e);
        }
    }
}

