/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.spi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Objects;
import org.opendaylight.jsonrpc.bus.api.SessionType;
import org.opendaylight.jsonrpc.bus.spi.CommonConstants;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public abstract class AbstractChannelInitializer
extends ChannelInitializer<SocketChannel> {
    protected final SessionType socketType;
    protected final EventExecutorGroup handlerExecutor;

    public AbstractChannelInitializer(SessionType socketType, EventExecutorGroup handlerExecutor) {
        this.socketType = Objects.requireNonNull(socketType);
        this.handlerExecutor = Objects.requireNonNull(handlerExecutor);
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ch.attr(CommonConstants.ATTR_SOCKET_TYPE).set((Object)this.socketType);
        ch.attr(CommonConstants.ATTR_HANDSHAKE_DONE).set((Object)false);
    }

    protected static void configureLogging(Channel channel) {
        if (CommonConstants.DEBUG_MODE) {
            channel.pipeline().addLast("logging", (ChannelHandler)CommonConstants.LOG_HANDLER);
        }
    }

    public EventExecutorGroup eventExecutor() {
        return this.handlerExecutor;
    }
}

