/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MJarSupport {
    private boolean mjar;
    private String prefix;
    private final Map<String, String> classes = new HashMap<String, String>();

    public boolean isMjar() {
        return this.mjar;
    }

    public Map<String, String> getClasses() {
        return this.classes;
    }

    public void load(InputStream is) throws IOException {
        this.load(new Manifest(is));
    }

    public void load(Manifest manifest) {
        Attributes mainAttributes = manifest.getMainAttributes();
        if (mainAttributes != null) {
            this.mjar = Boolean.parseBoolean(mainAttributes.getValue("Multi-Release"));
            if (this.mjar) {
                String javaVersion = System.getProperty("java.version", "1");
                int sep = javaVersion.indexOf(46);
                if (sep > 0) {
                    javaVersion = javaVersion.substring(0, sep);
                }
                this.prefix = "META-INF.versions." + javaVersion + '.';
            }
        }
    }

    public void visit(String name) {
        String normalized = name.replace('/', '.');
        if (normalized.startsWith("/")) {
            normalized = normalized.substring(1);
        }
        if (normalized.startsWith(this.prefix)) {
            this.classes.put(name.substring(this.prefix.length()), name + (!name.endsWith(".class") ? ".class" : ""));
        }
    }
}

