/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.transx.connector.impl;

import com.zaxxer.hikari.util.ClockSource;
import com.zaxxer.hikari.util.ConcurrentBag;
import com.zaxxer.hikari.util.UtilityElf;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import org.ops4j.pax.transx.connector.SubjectSource;
import org.ops4j.pax.transx.connector.impl.LocalXAResource;
import org.ops4j.pax.transx.connector.impl.MBeanHandler;
import org.ops4j.pax.transx.connector.impl.PoolConfigMXBean;
import org.ops4j.pax.transx.connector.impl.PoolMXBean;
import org.ops4j.pax.transx.connector.impl.RecoverableResourceFactoryImpl;
import org.ops4j.pax.transx.connector.impl.SubjectCRIKey;
import org.ops4j.pax.transx.connector.impl.WrapperNamedXAResource;
import org.ops4j.pax.transx.tm.NamedResource;
import org.ops4j.pax.transx.tm.ResourceFactory;
import org.ops4j.pax.transx.tm.Transaction;
import org.ops4j.pax.transx.tm.TransactionManager;

public class GenericConnectionManager
implements PoolConfigMXBean,
ConnectionManager,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(GenericConnectionManager.class.getName());
    private static final AtomicIntegerFieldUpdater<ManagedConnectionInfo> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ManagedConnectionInfo.class, "state");
    private static final Comparator<ManagedConnectionInfo> LASTACCESS_REVERSE_COMPARABLE = (entryOne, entryTwo) -> Long.compare(entryTwo.lastAccessed, entryOne.lastAccessed);
    private final TransactionManager transactionManager;
    private final SubjectSource subjectSource;
    private final ClassLoader classLoader;
    private final ManagedConnectionFactory managedConnectionFactory;
    private final String name;
    private final TransactionSupport.TransactionSupportLevel transactionSupportLevel;
    private volatile boolean destroyed = false;
    private final String mbeanName;
    private final String poolName;
    private final int maxPoolSize;
    private final int minIdle;
    private final long aliveBypassWindow;
    private final long houseKeepingPeriod;
    private final long connectionTimeout;
    private final long idleTimeout;
    private final long maxLifetime;
    private final ThreadPoolExecutor addConnectionExecutor;
    private final ThreadPoolExecutor closeConnectionExecutor;
    private final ScheduledExecutorService houseKeepingExecutorService;
    private ScheduledFuture<?> houseKeeperTask;
    private final ConcurrentMap<Transaction, ManagedConnectionInfo> infos = new ConcurrentHashMap<Transaction, ManagedConnectionInfo>();
    private final ConcurrentMap<SubjectCRIKey, Pool> pools = new ConcurrentHashMap<SubjectCRIKey, Pool>();

    public GenericConnectionManager(TransactionManager transactionManager, TransactionSupport.TransactionSupportLevel transactionSupportLevel, SubjectSource subjectSource, ClassLoader classLoader, ManagedConnectionFactory managedConnectionFactory, String name, String poolName, int minIdle, int maxPoolSize, long connectionTimeout, long idleTimeout, long maxLifetime, long aliveBypassWindow, long houseKeepingPeriod) {
        this.transactionManager = transactionManager;
        this.transactionSupportLevel = transactionSupportLevel;
        this.subjectSource = subjectSource;
        this.classLoader = classLoader;
        this.managedConnectionFactory = managedConnectionFactory;
        this.name = name;
        this.poolName = poolName;
        this.minIdle = minIdle;
        this.maxPoolSize = maxPoolSize;
        this.connectionTimeout = connectionTimeout;
        this.idleTimeout = idleTimeout;
        this.maxLifetime = maxLifetime;
        this.aliveBypassWindow = aliveBypassWindow;
        this.houseKeepingPeriod = houseKeepingPeriod;
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new UtilityElf.DefaultThreadFactory(poolName + " housekeeper", true), new ThreadPoolExecutor.DiscardPolicy());
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.setRemoveOnCancelPolicy(true);
        this.houseKeepingExecutorService = executor;
        this.addConnectionExecutor = UtilityElf.createThreadPoolExecutor(this.maxPoolSize, poolName + " connection adder", null, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardPolicy());
        this.closeConnectionExecutor = UtilityElf.createThreadPoolExecutor(this.maxPoolSize, poolName + " connection closer", null, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.houseKeeperTask = this.houseKeepingExecutorService.scheduleWithFixedDelay(this::houseKeep, 100L, this.houseKeepingPeriod, TimeUnit.MILLISECONDS);
        if (transactionManager != null && name != null) {
            transactionManager.registerResource((ResourceFactory)new RecoverableResourceFactoryImpl(managedConnectionFactory, name));
        }
        this.mbeanName = "org.ops4j.pax.transx:type=Pool,name=" + poolName;
        MBeanHandler.registerMBean(this, this.mbeanName);
    }

    @Override
    public int getMinIdle() {
        return this.minIdle;
    }

    @Override
    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public long getAliveBypassWindow() {
        return this.aliveBypassWindow;
    }

    @Override
    public long getHouseKeepingPeriod() {
        return this.houseKeepingPeriod;
    }

    private void houseKeep() {
        this.pools.values().forEach(Pool::houseKeep);
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        assert (managedConnectionFactory == this.managedConnectionFactory);
        Subject subject = this.subjectSource != null ? this.subjectSource.getSubject() : null;
        return this.allocateConnection(subject, connectionRequestInfo);
    }

    private Object allocateConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ManagedConnectionInfo mci = this.getMci(subject, connectionRequestInfo);
        return mci.getManagedConnection().getConnection(subject, connectionRequestInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedConnectionInfo getMci(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        ClassLoader prevClassLoader;
        block9: {
            Transaction transaction;
            block10: {
                ClassLoader cl;
                prevClassLoader = null;
                if (this.classLoader != null && (cl = Thread.currentThread().getContextClassLoader()) != this.classLoader) {
                    prevClassLoader = cl;
                    Thread.currentThread().setContextClassLoader(this.classLoader);
                }
                try {
                    Transaction transaction2 = transaction = this.transactionSupportLevel != TransactionSupport.TransactionSupportLevel.NoTransaction && this.transactionManager != null ? this.transactionManager.getTransaction() : null;
                    if (transaction == null || !transaction.isActive()) break block9;
                    ManagedConnectionInfo existing = (ManagedConnectionInfo)this.infos.get(transaction);
                    if (existing == null) break block10;
                    ManagedConnectionInfo managedConnectionInfo = existing;
                    if (prevClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                    return managedConnectionInfo;
                }
                catch (Throwable throwable) {
                    if (prevClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(prevClassLoader);
                    }
                    throw throwable;
                }
            }
            ManagedConnectionInfo mci = this.getMciFromPool(subject, connectionRequestInfo);
            this.infos.put(transaction, mci);
            transaction.synchronization(null, status -> {
                this.infos.remove(transaction);
                mci.requite();
            });
            mci.enlist(transaction);
            ManagedConnectionInfo managedConnectionInfo = mci;
            if (prevClassLoader != null) {
                Thread.currentThread().setContextClassLoader(prevClassLoader);
            }
            return managedConnectionInfo;
        }
        ManagedConnectionInfo managedConnectionInfo = this.getMciFromPool(subject, connectionRequestInfo);
        if (prevClassLoader != null) {
            Thread.currentThread().setContextClassLoader(prevClassLoader);
        }
        return managedConnectionInfo;
    }

    private ManagedConnectionInfo getMciFromPool(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        SubjectCRIKey key = new SubjectCRIKey(subject, connectionRequestInfo);
        Pool pool = this.pools.computeIfAbsent(key, x$0 -> new Pool((SubjectCRIKey)x$0));
        return this.getMciFromPool(pool, this.connectionTimeout);
    }

    private ManagedConnectionInfo getMciFromPool(Pool pool, long connectionTimeout) throws ResourceException {
        long startTime = ClockSource.currentTime();
        long timeout = connectionTimeout;
        ManagedConnectionInfo mci = null;
        try {
            while ((mci = pool.borrow(timeout, TimeUnit.MILLISECONDS)) != null) {
                long now = ClockSource.currentTime();
                if (!mci.isMarkedEvicted() && (ClockSource.elapsedMillis(mci.lastAccessed, now) <= this.aliveBypassWindow || this.isValid(mci))) {
                    mci.lastBorrowed = now;
                    return mci;
                }
                pool.closeConnection(mci, "(connection is evicted or dead)");
                timeout = connectionTimeout - ClockSource.elapsedMillis(startTime);
                if (timeout > 0L) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            if (mci != null) {
                mci.lastAccessed = startTime;
                pool.requite(mci);
            }
            Thread.currentThread().interrupt();
            throw new ResourceException(this.poolName + " - Interrupted during connection acquisition", (Throwable)e);
        }
        throw new ResourceException(this.poolName + " - Connection is not available, request timed out after " + ClockSource.elapsedMillis(startTime) + "ms.");
    }

    private boolean isValid(ManagedConnectionInfo mci) {
        if (this.managedConnectionFactory instanceof ValidatingManagedConnectionFactory) {
            try {
                Set s = ((ValidatingManagedConnectionFactory)this.managedConnectionFactory).getInvalidConnections(Collections.singleton(mci.getManagedConnection()));
                if (s != null && s.contains(mci.getManagedConnection())) {
                    return false;
                }
            }
            catch (ResourceException resourceException) {}
        } else {
            LOG.warning("Connection validation configured, but the ManagedConnectionFactory does not implement the ValidatingManagedConnectionFactory interface");
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        MBeanHandler.unregisterMBean(this.mbeanName);
        this.destroyed = true;
        if (this.houseKeeperTask != null) {
            this.houseKeeperTask.cancel(false);
            this.houseKeeperTask = null;
        }
        this.pools.values().forEach(Pool::softEvictConnections);
        this.addConnectionExecutor.shutdown();
        this.addConnectionExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        this.houseKeepingExecutorService.shutdownNow();
        this.pools.values().forEach(Pool::close);
        this.closeConnectionExecutor.shutdown();
        this.closeConnectionExecutor.awaitTermination(5L, TimeUnit.SECONDS);
        if (this.transactionManager != null && this.name != null) {
            this.transactionManager.unregisterResource(this.name);
        }
    }

    private void quietlyCloseConnection(ManagedConnectionInfo connection, String closureReason) {
        LOG.fine(() -> this.poolName + " - Closing connection " + connection + ": " + closureReason);
        try {
            connection.managedConnection.destroy();
        }
        catch (ResourceException e) {
            e.printStackTrace();
        }
    }

    final class ManagedConnectionInfo
    implements ConcurrentBag.IConcurrentBagEntry,
    ConnectionEventListener {
        final Pool pool;
        final ManagedConnection managedConnection;
        final NamedResource xares;
        volatile ScheduledFuture<?> endOfLife;
        volatile int state;
        volatile boolean evict;
        long lastAccessed;
        long lastBorrowed;
        Transaction transaction;

        ManagedConnectionInfo(Pool pool, ManagedConnection mc, NamedResource xares) {
            this.pool = pool;
            this.managedConnection = mc;
            this.xares = xares;
            mc.addConnectionEventListener((ConnectionEventListener)this);
        }

        @Override
        public int getState() {
            return STATE_UPDATER.get(this);
        }

        @Override
        public boolean compareAndSet(int expect, int update) {
            return STATE_UPDATER.compareAndSet(this, expect, update);
        }

        @Override
        public void setState(int update) {
            STATE_UPDATER.set(this, update);
        }

        boolean isMarkedEvicted() {
            return this.evict;
        }

        void markEvicted() {
            this.evict = true;
        }

        ManagedConnection getManagedConnection() {
            return this.managedConnection;
        }

        NamedResource getXAResource() {
            return this.xares;
        }

        void setFutureEol(ScheduledFuture<?> futureEol) {
            this.endOfLife = futureEol;
        }

        void requite() {
            this.transaction = null;
            try {
                this.managedConnection.cleanup();
                this.pool.requite(this);
            }
            catch (ResourceException e) {
                this.pool.closeConnection(this, "Cleanup error: " + (Object)((Object)e));
            }
        }

        void enlist(Transaction transaction) throws ResourceException {
            assert (this.transaction == null);
            try {
                transaction.enlistResource(this.xares);
                this.transaction = transaction;
            }
            catch (Exception e) {
                throw new ResourceException("Unable to enlist resource " + GenericConnectionManager.this.name, (Throwable)e);
            }
        }

        public void connectionClosed(ConnectionEvent event) {
            if (this.transaction != null) {
                return;
            }
            this.requite();
        }

        public void localTransactionStarted(ConnectionEvent event) {
        }

        public void localTransactionCommitted(ConnectionEvent event) {
        }

        public void localTransactionRolledback(ConnectionEvent event) {
        }

        public void connectionErrorOccurred(ConnectionEvent event) {
            this.pool.closeConnection(this, "Connection error: " + event.getException());
        }

        public String toString() {
            return "ManagedConnectionInfo[" + Integer.toHexString(this.hashCode()) + ", mc: " + this.managedConnection + ", state: " + this.stateToString() + "]";
        }

        private String stateToString() {
            switch (this.state) {
                case 1: {
                    return "IN_USE";
                }
                case 0: {
                    return "NOT_IN_USE";
                }
                case -1: {
                    return "REMOVED";
                }
                case -2: {
                    return "RESERVED";
                }
            }
            return "Invalid";
        }
    }

    final class Pool
    implements PoolMXBean {
        private final String mbeanName;
        private final SubjectCRIKey key;
        private final ConcurrentBag<ManagedConnectionInfo> bag;
        private volatile long previous;

        Pool(SubjectCRIKey key) {
            this.previous = ClockSource.plusMillis(ClockSource.currentTime(), -GenericConnectionManager.this.houseKeepingPeriod);
            this.key = key;
            this.bag = new ConcurrentBag(this::addNewConnection);
            this.mbeanName = "org.ops4j.pax.transx:type=Pool,name=" + GenericConnectionManager.this.poolName + ",subpool=" + key;
            MBeanHandler.registerMBean(this, this.mbeanName);
        }

        @Override
        public int getIdleConnections() {
            return this.bag.getCount(0);
        }

        @Override
        public int getActiveConnections() {
            return this.bag.getCount(1);
        }

        @Override
        public int getTotalConnections() {
            return this.bag.size();
        }

        private Future<Boolean> addNewConnection(int waiting) {
            return GenericConnectionManager.this.addConnectionExecutor.submit(() -> this.createConnection(null));
        }

        void fillPool() {
            int connectionsToAdd = Math.min(GenericConnectionManager.this.maxPoolSize - this.bag.size(), GenericConnectionManager.this.minIdle - this.bag.getCount(0));
            for (int i = 0; i < connectionsToAdd; ++i) {
                String afterPrefix = i < connectionsToAdd - 1 ? null : "After adding ";
                GenericConnectionManager.this.addConnectionExecutor.submit(() -> this.createConnection(afterPrefix));
            }
        }

        boolean createConnection(String afterPrefix) {
            long sleepBackoff = 250L;
            while (!GenericConnectionManager.this.destroyed && this.shouldCreateAnotherConnection()) {
                ManagedConnectionInfo mci = this.tryCreateManagedConnection();
                if (mci != null) {
                    this.bag.add(mci);
                    LOG.fine(GenericConnectionManager.this.poolName + " - Added connection " + mci.getManagedConnection());
                    if (afterPrefix != null) {
                        this.logPoolState(afterPrefix);
                    }
                    return true;
                }
                UtilityElf.quietlySleep(sleepBackoff);
                sleepBackoff = Math.min(TimeUnit.SECONDS.toMillis(10L), Math.min(GenericConnectionManager.this.connectionTimeout, (long)((double)sleepBackoff * 1.5)));
            }
            return false;
        }

        boolean shouldCreateAnotherConnection() {
            return this.bag.size() < GenericConnectionManager.this.maxPoolSize && (this.bag.getWaitingThreadCount() > 0 || this.bag.getCount(0) < GenericConnectionManager.this.minIdle);
        }

        void logPoolState(String prefix) {
            LOG.log(Level.FINE, () -> GenericConnectionManager.this.poolName + " - " + (prefix != null ? prefix : "") + "stats (total=" + this.bag.size() + ", active=" + this.bag.getCount(1) + ", idle=" + this.bag.getCount(0) + ", waiting=" + this.bag.getWaitingThreadCount() + ")");
        }

        void houseKeep() {
            try {
                long idleTimeout = GenericConnectionManager.this.idleTimeout;
                long now = ClockSource.currentTime();
                if (ClockSource.plusMillis(now, 128L) < ClockSource.plusMillis(this.previous, GenericConnectionManager.this.houseKeepingPeriod)) {
                    LOG.warning(() -> GenericConnectionManager.this.poolName + " - Retrograde clock change detected (housekeeper delta=" + ClockSource.elapsedDisplayString(this.previous, now) + "), soft-evicting connections from pool.");
                    this.previous = now;
                    this.softEvictConnections();
                    this.fillPool();
                    return;
                }
                if (now > ClockSource.plusMillis(this.previous, 3L * GenericConnectionManager.this.houseKeepingPeriod / 2L)) {
                    LOG.log(Level.WARNING, () -> GenericConnectionManager.this.poolName + " - Thread starvation or clock leap detected (housekeeper delta=" + ClockSource.elapsedDisplayString(this.previous, now) + ").");
                }
                this.previous = now;
                String afterPrefix = "Pool ";
                if (idleTimeout > 0L && GenericConnectionManager.this.minIdle < GenericConnectionManager.this.maxPoolSize) {
                    this.logPoolState("Before cleanup ");
                    afterPrefix = "After cleanup  ";
                    this.bag.values(0).stream().sorted(LASTACCESS_REVERSE_COMPARABLE).skip(GenericConnectionManager.this.minIdle).filter(mci -> ClockSource.elapsedMillis(mci.lastAccessed, now) > idleTimeout).filter(this.bag::reserve).forEachOrdered(mci -> this.closeConnection((ManagedConnectionInfo)mci, "(connection has passed idleTimeout)"));
                }
                this.logPoolState(afterPrefix);
                this.fillPool();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Unexpected exception in housekeeping task", e);
            }
        }

        void softEvictConnections() {
            this.bag.values().forEach(mci -> this.softEvictConnection((ManagedConnectionInfo)mci, "(connection evicted)", false));
        }

        void softEvictConnection(ManagedConnectionInfo mci, String reason, boolean owner) {
            mci.markEvicted();
            if (owner || this.bag.reserve(mci)) {
                this.closeConnection(mci, reason);
            }
        }

        void closeConnection(ManagedConnectionInfo mci, String closureReason) {
            if (this.bag.remove(mci)) {
                GenericConnectionManager.this.closeConnectionExecutor.execute(() -> {
                    GenericConnectionManager.this.quietlyCloseConnection(mci, closureReason);
                    if (!GenericConnectionManager.this.destroyed) {
                        this.fillPool();
                    }
                });
            }
        }

        void requite(ManagedConnectionInfo mci) {
            this.bag.requite(mci);
        }

        ManagedConnectionInfo borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.bag.borrow(timeout, timeUnit);
        }

        ManagedConnectionInfo tryCreateManagedConnection() {
            try {
                ManagedConnectionInfo mci = this.doCreateManagedConnection();
                long maxLifetime = GenericConnectionManager.this.maxLifetime;
                if (maxLifetime > 0L) {
                    long variance = maxLifetime > 10000L ? ThreadLocalRandom.current().nextLong(maxLifetime / 40L) : 0L;
                    long lifetime = maxLifetime - variance;
                    mci.setFutureEol(GenericConnectionManager.this.houseKeepingExecutorService.schedule(() -> this.softEvictConnection(mci, "(connection has passed maxLifetime)", false), lifetime, TimeUnit.MILLISECONDS));
                }
                return mci;
            }
            catch (Exception e) {
                if (!GenericConnectionManager.this.destroyed) {
                    LOG.log(Level.FINE, GenericConnectionManager.this.poolName + " - Cannot acquire connection from data source", e);
                }
                return null;
            }
        }

        ManagedConnectionInfo doCreateManagedConnection() throws ResourceException {
            ManagedConnection mc = GenericConnectionManager.this.managedConnectionFactory.createManagedConnection(this.key.getSubject(), this.key.getCri());
            Object xares = null;
            switch (GenericConnectionManager.this.transactionSupportLevel) {
                case LocalTransaction: {
                    xares = new LocalXAResource(mc.getLocalTransaction(), GenericConnectionManager.this.name);
                    break;
                }
                case XATransaction: {
                    xares = new WrapperNamedXAResource(mc.getXAResource(), GenericConnectionManager.this.name);
                    break;
                }
            }
            return new ManagedConnectionInfo(this, mc, (NamedResource)xares);
        }

        void close() {
            this.logPoolState("Before shutdown ");
            MBeanHandler.unregisterMBean(this.mbeanName);
            this.bag.close();
            this.bag.values().forEach(mci -> this.closeConnection((ManagedConnectionInfo)mci, "pool destroyed"));
        }
    }
}

