/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractForwardedDataBroker
extends AbstractBindingAdapter<DOMDataBroker> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractForwardedDataBroker.class);

    protected AbstractForwardedDataBroker(DOMDataBroker domDataBroker, BindingToNormalizedNodeCodec codec) {
        super(codec, domDataBroker);
    }

    protected Map<InstanceIdentifier<?>, DataObject> toBinding(InstanceIdentifier<?> path, Map<YangInstanceIdentifier, ? extends NormalizedNode<?, ?>> normalized) {
        HashMap newMap = new HashMap();
        for (Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> entry : normalized.entrySet()) {
            try {
                Optional<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>> potential = this.getCodec().toBinding(entry);
                if (!potential.isPresent()) continue;
                Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject> binding = potential.get();
                newMap.put(binding.getKey(), binding.getValue());
            }
            catch (DeserializationException e) {
                LOG.warn("Failed to transform {}, omitting it", entry, (Object)e);
            }
        }
        return newMap;
    }

    protected Set<InstanceIdentifier<?>> toBinding(InstanceIdentifier<?> path, Set<YangInstanceIdentifier> normalized) {
        HashSet hashSet = new HashSet();
        for (YangInstanceIdentifier normalizedPath : normalized) {
            try {
                Optional<InstanceIdentifier<? extends DataObject>> potential = this.getCodec().toBinding(normalizedPath);
                if (potential.isPresent()) {
                    InstanceIdentifier<? extends DataObject> binding = potential.get();
                    hashSet.add(binding);
                    continue;
                }
                if (!(normalizedPath.getLastPathArgument() instanceof YangInstanceIdentifier.AugmentationIdentifier)) continue;
                hashSet.add(path);
            }
            catch (DeserializationException e) {
                LOG.warn("Failed to transform {}, omitting it", (Object)normalizedPath, (Object)e);
            }
        }
        return hashSet;
    }

    protected Optional<DataObject> toBindingData(InstanceIdentifier<?> path, NormalizedNode<?, ?> data) {
        if (path.isWildcarded()) {
            return Optional.empty();
        }
        return (Optional)this.getCodec().getCodecRegistry().deserializeFunction(path).apply(Optional.of(data));
    }
}

