/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractForwardedTransaction;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public abstract class AbstractWriteTransaction<T extends DOMDataTreeWriteTransaction>
extends AbstractForwardedTransaction<T> {
    protected AbstractWriteTransaction(T delegate, BindingToNormalizedNodeCodec codec) {
        super(delegate, codec);
    }

    public final <U extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<U> path, U data, boolean createParents) {
        Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> normalized = this.toNormalized("put", path, data);
        if (createParents) {
            this.ensureParentsByMerge(store, normalized.getKey(), path);
        }
        ((DOMDataTreeWriteTransaction)this.getDelegate()).put(store, normalized.getKey(), normalized.getValue());
    }

    public final <U extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<U> path, U data, boolean createParents) {
        Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> normalized = this.toNormalized("merge", path, data);
        if (createParents) {
            this.ensureParentsByMerge(store, normalized.getKey(), path);
        }
        ((DOMDataTreeWriteTransaction)this.getDelegate()).merge(store, normalized.getKey(), normalized.getValue());
    }

    private <U extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> toNormalized(String operation, InstanceIdentifier<U> path, U data) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot %s data into wildcarded path %s", (Object)operation, path);
        return this.getCodec().toNormalizedNode(path, data);
    }

    @Deprecated
    protected static Optional<YangInstanceIdentifier> getParent(YangInstanceIdentifier child) {
        return Optional.ofNullable(child.getParent());
    }

    protected final void ensureParentsByMerge(LogicalDatastoreType store, YangInstanceIdentifier domPath, InstanceIdentifier<?> path) {
        YangInstanceIdentifier parentPath = domPath.getParent();
        if (parentPath != null) {
            NormalizedNode<?, ?> parentNode = this.getCodec().instanceIdentifierToNode(parentPath);
            ((DOMDataTreeWriteTransaction)this.getDelegate()).merge(store, YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument[])new YangInstanceIdentifier.PathArgument[]{parentNode.getIdentifier()}), parentNode);
        }
    }

    protected final void doDelete(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        Preconditions.checkArgument((!path.isWildcarded() ? 1 : 0) != 0, (String)"Cannot delete wildcarded path %s", path);
        YangInstanceIdentifier normalized = this.getCodec().toYangInstanceIdentifierBlocking(path);
        ((DOMDataTreeWriteTransaction)this.getDelegate()).delete(store, normalized);
    }

    protected final @NonNull FluentFuture<? extends @NonNull CommitInfo> doCommit() {
        return ((DOMDataTreeWriteTransaction)this.getDelegate()).commit();
    }

    protected final boolean doCancel() {
        return ((DOMDataTreeWriteTransaction)this.getDelegate()).cancel();
    }
}

