/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FluentFuture;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingOperationFluentFuture;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionResult;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.AbstractObjectRegistration;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Beta
@NonNullByDefault
public final class ActionProviderServiceAdapter
extends AbstractBindingAdapter<DOMActionProviderService>
implements ActionProviderService {
    static final BindingDOMAdapterBuilder.Factory<ActionProviderService> BUILDER_FACTORY = () -> new Builder();

    ActionProviderServiceAdapter(BindingToNormalizedNodeCodec codec, DOMActionProviderService delegate) {
        super(codec, delegate);
    }

    @Deprecated
    public static ActionProviderServiceAdapter create(BindingToNormalizedNodeCodec codec, DOMActionProviderService delegate) {
        return new ActionProviderServiceAdapter(codec, delegate);
    }

    public <O extends DataObject, P extends InstanceIdentifier<O>, T extends Action<P, ?, ?>, S extends T> ObjectRegistration<S> registerImplementation(Class<T> actionInterface, S implementation, LogicalDatastoreType datastore, Set<DataTreeIdentifier<O>> validNodes) {
        SchemaPath path = this.getCodec().getActionPath(actionInterface);
        final ObjectRegistration reg = ((DOMActionProviderService)this.getDelegate()).registerActionImplementation((DOMActionImplementation)new Impl(this.getCodec(), YangInstanceIdentifier.NodeIdentifier.create((QName)YangConstants.operationOutputQName((QNameModule)path.getLastComponent().getModule())), (Class<? extends Action<?, ?, ?>>)actionInterface, (Action<?, ?, ?>)implementation), (Set)ImmutableSet.of());
        return new AbstractObjectRegistration<S>((Action)implementation){

            protected void removeRegistration() {
                reg.close();
            }
        };
    }

    private static final class Impl
    implements DOMActionImplementation {
        private final Class<? extends Action<?, ?, ?>> actionInterface;
        private final Action implementation;
        private final BindingNormalizedNodeSerializer codec;
        private final YangInstanceIdentifier.NodeIdentifier outputName;

        Impl(BindingNormalizedNodeSerializer codec, YangInstanceIdentifier.NodeIdentifier outputName, Class<? extends Action<?, ?, ?>> actionInterface, Action<?, ?, ?> implementation) {
            this.codec = Objects.requireNonNull(codec);
            this.outputName = Objects.requireNonNull(outputName);
            this.actionInterface = Objects.requireNonNull(actionInterface);
            this.implementation = Objects.requireNonNull(implementation);
        }

        public FluentFuture<? extends DOMActionResult> invokeAction(SchemaPath type, DOMDataTreeIdentifier path, ContainerNode input) {
            FluentFuture userFuture = this.implementation.invoke(this.codec.fromYangInstanceIdentifier(path.getRootIdentifier()), this.codec.fromNormalizedNodeActionInput(this.actionInterface, input));
            if (userFuture instanceof BindingOperationFluentFuture) {
                return (BindingOperationFluentFuture)userFuture;
            }
            return new BindingOperationFluentFuture(userFuture, this.actionInterface, this.outputName, this.codec);
        }
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<ActionProviderService> {
        private Builder() {
        }

        @Override
        protected ActionProviderService createInstance(@Nullable BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMActionProviderService domAction = (DOMActionProviderService)delegates.getInstance(DOMActionProviderService.class);
            return new ActionProviderServiceAdapter(Objects.requireNonNull(codec), domAction);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMActionProviderService.class);
        }
    }
}

