/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.FluentFuture;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.api.ActionService;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingLoadingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ActionAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.RpcResult;

@Beta
@NonNullByDefault
public final class ActionServiceAdapter
extends AbstractBindingLoadingAdapter<DOMActionService, Class<? extends Action<?, ?, ?>>, ActionAdapter>
implements ActionService {
    static final BindingDOMAdapterBuilder.Factory<ActionService> BUILDER_FACTORY = () -> new Builder();

    ActionServiceAdapter(BindingToNormalizedNodeCodec codec, DOMActionService delegate) {
        super(codec, delegate);
    }

    @Deprecated
    public static ActionServiceAdapter create(BindingToNormalizedNodeCodec codec, DOMActionService delegate) {
        return new ActionServiceAdapter(codec, delegate);
    }

    public <O extends DataObject, T extends Action<?, ?, ?>> T getActionHandle(Class<T> actionInterface, Set<DataTreeIdentifier<O>> nodes) {
        return (T)(!nodes.isEmpty() ? new ConstrainedAction((Action<?, ?, ?>)this.getActionHandle(actionInterface, (Set<DataTreeIdentifier<O>>)ImmutableSet.of()), (Set<? extends DataTreeIdentifier<?>>)nodes) : (Action)Proxy.newProxyInstance(actionInterface.getClassLoader(), new Class[]{actionInterface}, (InvocationHandler)this.getAdapter(actionInterface)));
    }

    @Override
    ActionAdapter loadAdapter(Class<? extends Action<?, ?, ?>> key) {
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(key));
        Preconditions.checkArgument((boolean)key.isInterface(), (Object)"Supplied Action type must be an interface.");
        return new ActionAdapter(this.getCodec(), (DOMActionService)this.getDelegate(), key);
    }

    private static final class ConstrainedAction
    implements Delegator<Action<?, ?, ?>>,
    Action<InstanceIdentifier<?>, RpcInput, RpcOutput> {
        private final Action<InstanceIdentifier<?>, RpcInput, RpcOutput> delegate;
        private final Set<? extends DataTreeIdentifier<?>> nodes;

        ConstrainedAction(Action<?, ?, ?> delegate, Set<? extends DataTreeIdentifier<?>> nodes) {
            this.delegate = Objects.requireNonNull(delegate);
            this.nodes = Objects.requireNonNull(nodes);
        }

        public FluentFuture<RpcResult<RpcOutput>> invoke(InstanceIdentifier<?> path, RpcInput input) {
            Preconditions.checkState((boolean)this.nodes.contains(DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, path)), (String)"Cannot service %s", path);
            return this.delegate.invoke(path, input);
        }

        public Action<?, ?, ?> getDelegate() {
            return this.delegate;
        }
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<ActionService> {
        private Builder() {
        }

        @Override
        protected ActionService createInstance(@Nullable BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMActionService domAction = (DOMActionService)delegates.getInstance(DOMActionService.class);
            return new ActionServiceAdapter(Objects.requireNonNull(codec), domAction);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMActionService.class);
        }
    }
}

