/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

class BindingDOMDataTreeChangeListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final BindingToNormalizedNodeCodec codec;
    private final DataTreeChangeListener<T> listener;
    private final LogicalDatastoreType store;

    BindingDOMDataTreeChangeListenerAdapter(BindingToNormalizedNodeCodec codec, DataTreeChangeListener<T> listener, LogicalDatastoreType store) {
        this.codec = Objects.requireNonNull(codec);
        this.listener = Objects.requireNonNull(listener);
        this.store = Objects.requireNonNull(store);
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> domChanges) {
        Collection bindingChanges = LazyDataTreeModification.from(this.codec, domChanges, this.store);
        this.listener.onDataTreeChanged(bindingChanges);
    }

    public void onInitialData() {
        this.listener.onInitialData();
    }
}

