/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeService;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingClusteredDOMDataTreeChangeListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeChangeListenerAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDataTreeChangeListenerRegistration;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

final class BindingDOMDataTreeChangeServiceAdapter
extends AbstractBindingAdapter<DOMDataTreeChangeService>
implements DataTreeChangeService {
    private BindingDOMDataTreeChangeServiceAdapter(BindingToNormalizedNodeCodec codec, DOMDataTreeChangeService dataTreeChangeService) {
        super(codec, dataTreeChangeService);
    }

    static DataTreeChangeService create(BindingToNormalizedNodeCodec codec, DOMDataTreeChangeService dataTreeChangeService) {
        return new BindingDOMDataTreeChangeServiceAdapter(codec, dataTreeChangeService);
    }

    public <T extends DataObject, L extends DataTreeChangeListener<T>> ListenerRegistration<L> registerDataTreeChangeListener(DataTreeIdentifier<T> treeId, L listener) {
        DOMDataTreeIdentifier domIdentifier = this.toDomTreeIdentifier(treeId);
        LogicalDatastoreType storeType = treeId.getDatastoreType();
        BindingDOMDataTreeChangeListenerAdapter domListener = listener instanceof ClusteredDataTreeChangeListener ? new BindingClusteredDOMDataTreeChangeListenerAdapter(this.getCodec(), (ClusteredDataTreeChangeListener)listener, storeType) : new BindingDOMDataTreeChangeListenerAdapter(this.getCodec(), listener, storeType);
        ListenerRegistration domReg = ((DOMDataTreeChangeService)this.getDelegate()).registerDataTreeChangeListener(domIdentifier, domListener);
        return new BindingDataTreeChangeListenerRegistration<L>(listener, domReg);
    }

    private DOMDataTreeIdentifier toDomTreeIdentifier(DataTreeIdentifier<?> treeId) {
        YangInstanceIdentifier domPath = this.getCodec().toYangInstanceIdentifierBlocking((InstanceIdentifier<? extends DataObject>)treeId.getRootIdentifier());
        return new DOMDataTreeIdentifier(treeId.getDatastoreType(), domPath);
    }
}

