/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeListener;
import org.opendaylight.mdsal.binding.api.DataTreeListeningException;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataTreeModification;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListeningException;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

public class BindingDOMDataTreeListenerAdapter
extends AbstractBindingAdapter<DataTreeListener>
implements DOMDataTreeListener {
    private final LogicalDatastoreType store;

    protected BindingDOMDataTreeListenerAdapter(DataTreeListener delegate, BindingToNormalizedNodeCodec codec, LogicalDatastoreType store) {
        super(codec, delegate);
        this.store = Objects.requireNonNull(store, "store");
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> domChanges, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> domSubtrees) {
        Collection<DataTreeModification<?>> changes = this.toBinding(domChanges);
        Map<DataTreeIdentifier<?>, DataObject> subtrees = this.toBinding(domSubtrees);
        ((DataTreeListener)this.getDelegate()).onDataTreeChanged(changes, subtrees);
    }

    private Map<DataTreeIdentifier<?>, DataObject> toBinding(Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> domSubtrees) {
        HashMap ret = Maps.newHashMapWithExpectedSize((int)domSubtrees.size());
        for (Map.Entry<DOMDataTreeIdentifier, NormalizedNode<?, ?>> domEntry : domSubtrees.entrySet()) {
            Map.Entry<InstanceIdentifier<?>, DataObject> bindingEntry = this.getCodec().fromNormalizedNode(domEntry.getKey().getRootIdentifier(), domEntry.getValue());
            ret.put(DataTreeIdentifier.create((LogicalDatastoreType)this.store, bindingEntry.getKey()), bindingEntry.getValue());
        }
        return ret;
    }

    private Collection<DataTreeModification<?>> toBinding(Collection<DataTreeCandidate> domChanges) {
        return (Collection)Collection.class.cast(LazyDataTreeModification.from(this.getCodec(), domChanges, this.store));
    }

    public void onDataTreeFailed(Collection<DOMDataTreeListeningException> causes) {
        ArrayList<DataTreeListeningException> bindingCauses = new ArrayList<DataTreeListeningException>(causes.size());
        for (DOMDataTreeListeningException cause : causes) {
            bindingCauses.add(BindingDOMDataTreeListenerAdapter.mapException(cause));
        }
        ((DataTreeListener)this.getDelegate()).onDataTreeFailed(bindingCauses);
    }

    private static DataTreeListeningException mapException(DOMDataTreeListeningException cause) {
        return new DataTreeListeningException(cause.getMessage(), (Throwable)cause);
    }
}

