/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.annotations.VisibleForTesting;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeWriteCursor;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public class BindingDOMDataTreeWriteCursorAdapter<T extends DOMDataTreeWriteCursor>
extends AbstractBindingAdapter<T>
implements DataTreeWriteCursor {
    private final Deque<InstanceIdentifier.PathArgument> stack = new ArrayDeque<InstanceIdentifier.PathArgument>();

    public BindingDOMDataTreeWriteCursorAdapter(DataTreeIdentifier<?> path, T delegate, BindingToNormalizedNodeCodec codec) {
        super(codec, delegate);
        path.getRootIdentifier().getPathArguments().forEach(this.stack::push);
    }

    private YangInstanceIdentifier.PathArgument convertToNormalized(InstanceIdentifier.PathArgument child) {
        this.stack.push(child);
        InstanceIdentifier iid = InstanceIdentifier.create(this.stack);
        YangInstanceIdentifier ret = this.getCodec().toNormalized((InstanceIdentifier<? extends DataObject>)iid);
        this.stack.pop();
        return ret.getLastPathArgument();
    }

    private <P extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> convertToNormalized(InstanceIdentifier.PathArgument child, P data) {
        this.stack.push(child);
        InstanceIdentifier iid = InstanceIdentifier.create(this.stack);
        Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> entry = this.getCodec().toNormalizedNode(new AbstractMap.SimpleEntry<InstanceIdentifier<? extends DataObject>, DataObject>(iid, data));
        this.stack.pop();
        return entry;
    }

    public void delete(InstanceIdentifier.PathArgument child) {
        ((DOMDataTreeWriteCursor)this.getDelegate()).delete(this.convertToNormalized(child));
    }

    public <P extends DataObject> void merge(InstanceIdentifier.PathArgument child, P data) {
        Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> entry = this.convertToNormalized(child, data);
        ((DOMDataTreeWriteCursor)this.getDelegate()).merge(entry.getKey().getLastPathArgument(), entry.getValue());
    }

    public <P extends DataObject> void write(InstanceIdentifier.PathArgument child, P data) {
        Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> entry = this.convertToNormalized(child, data);
        ((DOMDataTreeWriteCursor)this.getDelegate()).write(entry.getKey().getLastPathArgument(), entry.getValue());
    }

    public void enter(InstanceIdentifier.PathArgument child) {
        this.stack.push(child);
    }

    public void enter(InstanceIdentifier.PathArgument ... path) {
        for (InstanceIdentifier.PathArgument pathArgument : path) {
            this.enter(pathArgument);
        }
    }

    public void enter(Iterable<InstanceIdentifier.PathArgument> path) {
        path.forEach(this::enter);
    }

    public void exit() {
        this.stack.pop();
    }

    public void exit(int depth) {
        for (int i = 0; i < depth; ++i) {
            this.exit();
        }
    }

    public void close() {
        ((DOMDataTreeWriteCursor)this.getDelegate()).close();
    }

    @VisibleForTesting
    Deque<InstanceIdentifier.PathArgument> stack() {
        return this.stack;
    }
}

