/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opendaylight.mdsal.binding.api.NotificationPublishService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMAdapterBuilder;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.adapter.LazySerializedDOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.binding.Notification;

public class BindingDOMNotificationPublishServiceAdapter
extends AbstractBindingAdapter<DOMNotificationPublishService>
implements NotificationPublishService {
    static final BindingDOMAdapterBuilder.Factory<NotificationPublishService> BUILDER_FACTORY = Builder::new;

    public BindingDOMNotificationPublishServiceAdapter(DOMNotificationPublishService domPublishService, BindingToNormalizedNodeCodec codec) {
        super(codec, domPublishService);
    }

    @Deprecated
    public BindingDOMNotificationPublishServiceAdapter(BindingToNormalizedNodeCodec codec, DOMNotificationPublishService domPublishService) {
        this(domPublishService, codec);
    }

    public BindingToNormalizedNodeCodec getCodecRegistry() {
        return this.getCodec();
    }

    public DOMNotificationPublishService getDomPublishService() {
        return (DOMNotificationPublishService)this.getDelegate();
    }

    public void putNotification(Notification notification) throws InterruptedException {
        ((DOMNotificationPublishService)this.getDelegate()).putNotification(this.toDomNotification(notification));
    }

    public ListenableFuture<? extends Object> offerNotification(Notification notification) {
        ListenableFuture offerResult = ((DOMNotificationPublishService)this.getDelegate()).offerNotification(this.toDomNotification(notification));
        return DOMNotificationPublishService.REJECTED.equals(offerResult) ? NotificationPublishService.REJECTED : offerResult;
    }

    public ListenableFuture<? extends Object> offerNotification(Notification notification, int timeout, TimeUnit unit) throws InterruptedException {
        ListenableFuture offerResult = ((DOMNotificationPublishService)this.getDelegate()).offerNotification(this.toDomNotification(notification), (long)timeout, unit);
        return DOMNotificationPublishService.REJECTED.equals(offerResult) ? NotificationPublishService.REJECTED : offerResult;
    }

    private DOMNotification toDomNotification(Notification notification) {
        return LazySerializedDOMNotification.create(this.getCodec(), notification);
    }

    protected static class Builder
    extends BindingDOMAdapterBuilder<NotificationPublishService> {
        protected Builder() {
        }

        @Override
        public Set<Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationPublishService.class);
        }

        @Override
        protected NotificationPublishService createInstance(BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMNotificationPublishService domPublish = (DOMNotificationPublishService)delegates.getInstance(DOMNotificationPublishService.class);
            return new BindingDOMNotificationPublishServiceAdapter(codec, domPublish);
        }
    }
}

