/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDataAware;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDOMRpcResultFuture;
import org.opendaylight.mdsal.binding.dom.adapter.StaticConfiguration;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcServiceInvoker;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangConstants;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class BindingDOMRpcImplementationAdapter
implements DOMRpcImplementation {
    private static final Cache<Class<?>, RpcServiceInvoker> SERVICE_INVOKERS = CacheBuilder.newBuilder().weakKeys().build();
    private static final int COST = 1;
    private final BindingNormalizedNodeCodecRegistry codec;
    private final RpcServiceInvoker invoker;
    private final RpcService delegate;
    private final QName inputQname;

    <T extends RpcService> BindingDOMRpcImplementationAdapter(BindingNormalizedNodeCodecRegistry codec, Class<T> type, Map<SchemaPath, Method> localNameToMethod, T delegate) {
        try {
            this.invoker = (RpcServiceInvoker)SERVICE_INVOKERS.get(type, () -> {
                HashMap<QName, Method> map = new HashMap<QName, Method>();
                for (Map.Entry e : localNameToMethod.entrySet()) {
                    map.put(((SchemaPath)e.getKey()).getLastComponent(), (Method)e.getValue());
                }
                return RpcServiceInvoker.from(map);
            });
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Failed to create invokers for type " + type, e);
        }
        this.codec = Objects.requireNonNull(codec);
        this.delegate = Objects.requireNonNull(delegate);
        this.inputQname = YangConstants.operationInputQName((QNameModule)BindingReflections.getQNameModule(type)).intern();
    }

    public FluentFuture<DOMRpcResult> invokeRpc(DOMRpcIdentifier rpc, NormalizedNode<?, ?> input) {
        SchemaPath schemaPath = rpc.getType();
        DataObject bindingInput = input != null ? this.deserialize(rpc.getType(), input) : null;
        ListenableFuture<RpcResult<?>> bindingResult = this.invoke(schemaPath, bindingInput);
        return LazyDOMRpcResultFuture.create(this.codec, bindingResult);
    }

    public long invocationCost() {
        return 1L;
    }

    private DataObject deserialize(SchemaPath rpcPath, NormalizedNode<?, ?> input) {
        if (StaticConfiguration.ENABLE_CODEC_SHORTCUT && input instanceof BindingDataAware) {
            return ((BindingDataAware)input).bindingData();
        }
        SchemaPath inputSchemaPath = rpcPath.createChild(this.inputQname);
        return this.codec.fromNormalizedNodeRpcData(inputSchemaPath, (ContainerNode)input);
    }

    private ListenableFuture<RpcResult<?>> invoke(SchemaPath schemaPath, DataObject input) {
        return this.invoker.invokeRpc(this.delegate, schemaPath.getLastComponent(), input);
    }
}

