/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.binding.api.RpcProviderService;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractBindingAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMRpcImplementationAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.BindingRpcAdapterRegistration;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationRegistration;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

public class BindingDOMRpcProviderServiceAdapter
extends AbstractBindingAdapter<DOMRpcProviderService>
implements RpcProviderService {
    private static final ImmutableSet<YangInstanceIdentifier> GLOBAL = ImmutableSet.of((Object)YangInstanceIdentifier.EMPTY);

    public BindingDOMRpcProviderServiceAdapter(DOMRpcProviderService domRpcRegistry, BindingToNormalizedNodeCodec codec) {
        super(codec, domRpcRegistry);
    }

    public <S extends RpcService, T extends S> ObjectRegistration<T> registerRpcImplementation(Class<S> type, T implementation) {
        return this.register(type, implementation, (Collection<YangInstanceIdentifier>)GLOBAL);
    }

    public <S extends RpcService, T extends S> ObjectRegistration<T> registerRpcImplementation(Class<S> type, T implementation, Set<InstanceIdentifier<?>> paths) {
        return this.register(type, implementation, this.toYangInstanceIdentifiers(paths));
    }

    private <S extends RpcService, T extends S> ObjectRegistration<T> register(Class<S> type, T implementation, Collection<YangInstanceIdentifier> rpcContextPaths) {
        ImmutableBiMap rpcs = this.getCodec().getRpcMethodToSchemaPath(type).inverse();
        BindingDOMRpcImplementationAdapter adapter = new BindingDOMRpcImplementationAdapter(this.getCodec().getCodecRegistry(), type, (Map<SchemaPath, Method>)rpcs, implementation);
        Set<DOMRpcIdentifier> domRpcs = BindingDOMRpcProviderServiceAdapter.createDomRpcIdentifiers(rpcs.keySet(), rpcContextPaths);
        DOMRpcImplementationRegistration domReg = ((DOMRpcProviderService)this.getDelegate()).registerRpcImplementation((DOMRpcImplementation)adapter, domRpcs);
        return new BindingRpcAdapterRegistration<T>(implementation, domReg);
    }

    private static Set<DOMRpcIdentifier> createDomRpcIdentifiers(Set<SchemaPath> rpcs, Collection<YangInstanceIdentifier> paths) {
        HashSet<DOMRpcIdentifier> ret = new HashSet<DOMRpcIdentifier>();
        for (YangInstanceIdentifier path : paths) {
            for (SchemaPath rpc : rpcs) {
                ret.add(DOMRpcIdentifier.create((SchemaPath)rpc, (YangInstanceIdentifier)path));
            }
        }
        return ret;
    }

    private Collection<YangInstanceIdentifier> toYangInstanceIdentifiers(Set<InstanceIdentifier<?>> identifiers) {
        ArrayList<YangInstanceIdentifier> ret = new ArrayList<YangInstanceIdentifier>(identifiers.size());
        for (InstanceIdentifier<?> binding : identifiers) {
            ret.add(this.getCodec().toYangInstanceIdentifierCached(binding));
        }
        return ret;
    }
}

