/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javassist.ClassPool;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.adapter.FutureSchema;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingLazyContainerNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.StreamWriterGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.dom.codec.impl.MissingSchemaException;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingToNormalizedNodeCodec
implements BindingCodecTreeFactory,
BindingNormalizedNodeSerializer,
SchemaContextListener,
AutoCloseable {
    private static final long WAIT_DURATION_SEC = 5L;
    private static final Logger LOG = LoggerFactory.getLogger(BindingToNormalizedNodeCodec.class);
    private final LoadingCache<InstanceIdentifier<?>, YangInstanceIdentifier> iiCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<InstanceIdentifier<?>, YangInstanceIdentifier>(){

        public YangInstanceIdentifier load(InstanceIdentifier<?> key) {
            return BindingToNormalizedNodeCodec.this.toYangInstanceIdentifierBlocking(key);
        }
    });
    private final BindingNormalizedNodeCodecRegistry codecRegistry;
    private final ClassLoadingStrategy classLoadingStrategy;
    private final FutureSchema futureSchema;
    private ListenerRegistration<?> listenerRegistration;

    public BindingToNormalizedNodeCodec(ClassLoadingStrategy classLoadingStrategy, BindingNormalizedNodeCodecRegistry codecRegistry) {
        this(classLoadingStrategy, codecRegistry, false);
    }

    public BindingToNormalizedNodeCodec(ClassLoadingStrategy classLoadingStrategy, BindingNormalizedNodeCodecRegistry codecRegistry, boolean waitForSchema) {
        this.classLoadingStrategy = Objects.requireNonNull(classLoadingStrategy, "classLoadingStrategy");
        this.codecRegistry = Objects.requireNonNull(codecRegistry, "codecRegistry");
        this.futureSchema = FutureSchema.create(5L, TimeUnit.SECONDS, waitForSchema);
    }

    public static BindingToNormalizedNodeCodec newInstance(ClassLoadingStrategy classLoadingStrategy, DOMSchemaService schemaService) {
        BindingNormalizedNodeCodecRegistry codecRegistry = new BindingNormalizedNodeCodecRegistry(StreamWriterGenerator.create((JavassistUtils)JavassistUtils.forClassPool((ClassPool)ClassPool.getDefault())));
        BindingToNormalizedNodeCodec instance = new BindingToNormalizedNodeCodec(classLoadingStrategy, codecRegistry, true);
        instance.listenerRegistration = schemaService.registerSchemaContextListener((SchemaContextListener)instance);
        return instance;
    }

    protected YangInstanceIdentifier toYangInstanceIdentifierBlocking(InstanceIdentifier<? extends DataObject> binding) {
        try {
            return this.codecRegistry.toYangInstanceIdentifier(binding);
        }
        catch (MissingSchemaException e) {
            this.waitForSchema(BindingToNormalizedNodeCodec.decompose(binding), e);
            return this.codecRegistry.toYangInstanceIdentifier(binding);
        }
    }

    public final YangInstanceIdentifier toNormalized(InstanceIdentifier<? extends DataObject> binding) {
        return this.codecRegistry.toYangInstanceIdentifier(binding);
    }

    public final YangInstanceIdentifier toYangInstanceIdentifier(InstanceIdentifier<?> binding) {
        return this.codecRegistry.toYangInstanceIdentifier(binding);
    }

    protected YangInstanceIdentifier toYangInstanceIdentifierCached(InstanceIdentifier<?> binding) {
        return (YangInstanceIdentifier)this.iiCache.getUnchecked(binding);
    }

    public final <T extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> toNormalizedNode(InstanceIdentifier<T> path, T data) {
        try {
            return this.codecRegistry.toNormalizedNode(path, data);
        }
        catch (MissingSchemaException e) {
            this.waitForSchema(BindingToNormalizedNodeCodec.decompose(path), e);
            return this.codecRegistry.toNormalizedNode(path, data);
        }
    }

    public final Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> toNormalizedNode(Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject> binding) {
        return this.toNormalizedNode(binding.getKey(), binding.getValue());
    }

    public final Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        return this.codecRegistry.fromNormalizedNode(path, data);
    }

    public final Notification fromNormalizedNodeNotification(SchemaPath path, ContainerNode data) {
        return this.codecRegistry.fromNormalizedNodeNotification(path, data);
    }

    public final DataObject fromNormalizedNodeRpcData(SchemaPath path, ContainerNode data) {
        return this.codecRegistry.fromNormalizedNodeRpcData(path, data);
    }

    public <T extends RpcInput> T fromNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, ContainerNode input) {
        return (T)this.codecRegistry.fromNormalizedNodeActionInput(action, input);
    }

    public <T extends RpcOutput> T fromNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, ContainerNode output) {
        return (T)this.codecRegistry.fromNormalizedNodeActionOutput(action, output);
    }

    public final InstanceIdentifier<?> fromYangInstanceIdentifier(YangInstanceIdentifier dom) {
        return this.codecRegistry.fromYangInstanceIdentifier(dom);
    }

    public final ContainerNode toNormalizedNodeNotification(Notification data) {
        return this.codecRegistry.toNormalizedNodeNotification(data);
    }

    public final ContainerNode toNormalizedNodeRpcData(DataContainer data) {
        return this.codecRegistry.toNormalizedNodeRpcData(data);
    }

    public ContainerNode toNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, RpcInput input) {
        return this.codecRegistry.toNormalizedNodeActionInput(action, input);
    }

    public ContainerNode toNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, RpcOutput output) {
        return this.codecRegistry.toNormalizedNodeActionOutput(action, output);
    }

    public BindingLazyContainerNode<RpcInput> toLazyNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcInput input) {
        return this.codecRegistry.toLazyNormalizedNodeActionInput(action, identifier, input);
    }

    public BindingLazyContainerNode<RpcOutput> toLazyNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, YangInstanceIdentifier.NodeIdentifier identifier, RpcOutput output) {
        return this.codecRegistry.toLazyNormalizedNodeActionOutput(action, identifier, output);
    }

    public final Optional<InstanceIdentifier<? extends DataObject>> toBinding(YangInstanceIdentifier normalized) throws DeserializationException {
        try {
            return Optional.ofNullable(this.codecRegistry.fromYangInstanceIdentifier(normalized));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public final Optional<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>> toBinding( @NonNull Map.Entry<YangInstanceIdentifier, ? extends NormalizedNode<?, ?>> normalized) throws DeserializationException {
        try {
            Map.Entry binding = (Map.Entry)Map.Entry.class.cast(this.codecRegistry.fromNormalizedNode(normalized.getKey(), normalized.getValue()));
            return Optional.ofNullable(binding);
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public void onGlobalContextUpdated(SchemaContext context) {
        BindingRuntimeContext runtimeContext = BindingRuntimeContext.create((ClassLoadingStrategy)this.classLoadingStrategy, (SchemaContext)context);
        this.codecRegistry.onBindingRuntimeContextUpdated(runtimeContext);
        this.futureSchema.onRuntimeContextUpdated(runtimeContext);
    }

    @Deprecated
    public final <T extends DataObject> Function<Optional<NormalizedNode<?, ?>>, Optional<T>> deserializeFunction(InstanceIdentifier<T> path) {
        return this.codecRegistry.deserializeFunction(path)::apply;
    }

    public final BindingNormalizedNodeCodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public void close() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.close();
        }
    }

    public final BindingNormalizedNodeCodecRegistry getCodecFactory() {
        return this.codecRegistry;
    }

    public final ImmutableBiMap<Method, SchemaPath> getRpcMethodToSchemaPath(Class<? extends RpcService> key) {
        Module module = this.getModuleBlocking(key);
        ImmutableBiMap.Builder ret = ImmutableBiMap.builder();
        try {
            for (RpcDefinition rpcDef : module.getRpcs()) {
                Method method = this.findRpcMethod(key, rpcDef);
                ret.put((Object)method, (Object)rpcDef.getPath());
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Rpc defined in model does not have representation in generated class.", e);
        }
        return ret.build();
    }

    protected ImmutableBiMap<Method, RpcDefinition> getRpcMethodToSchema(Class<? extends RpcService> key) {
        Module module = this.getModuleBlocking(key);
        ImmutableBiMap.Builder ret = ImmutableBiMap.builder();
        try {
            for (RpcDefinition rpcDef : module.getRpcs()) {
                Method method = this.findRpcMethod(key, rpcDef);
                ret.put((Object)method, (Object)rpcDef);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Rpc defined in model does not have representation in generated class.", e);
        }
        return ret.build();
    }

    private Module getModuleBlocking(Class<?> modeledClass) {
        Module module;
        QNameModule moduleName = BindingReflections.getQNameModule(modeledClass);
        BindingRuntimeContext localRuntimeContext = this.runtimeContext();
        Module module2 = module = localRuntimeContext == null ? null : (Module)localRuntimeContext.getSchemaContext().findModule(moduleName).orElse(null);
        if (module == null && this.futureSchema.waitForSchema(moduleName)) {
            localRuntimeContext = this.runtimeContext();
            Preconditions.checkState((localRuntimeContext != null ? 1 : 0) != 0, (Object)"BindingRuntimeContext is not available.");
            module = localRuntimeContext.getSchemaContext().findModule(moduleName).orElse(null);
        }
        if (module != null) {
            return module;
        }
        LOG.debug("Schema for {} is not available; expected module name: {}; BindingRuntimeContext: {}", new Object[]{modeledClass, moduleName, localRuntimeContext});
        throw new IllegalStateException(String.format("Schema for %s is not available; expected module name: %s; full BindingRuntimeContext available in debug log", modeledClass, moduleName));
    }

    private void waitForSchema(Collection<Class<?>> binding, MissingSchemaException exception) {
        LOG.warn("Blocking thread to wait for schema convergence updates for {} {}", (Object)this.futureSchema.getDuration(), (Object)this.futureSchema.getUnit());
        if (!this.futureSchema.waitForSchema(binding)) {
            throw exception;
        }
    }

    private Method findRpcMethod(Class<? extends RpcService> key, RpcDefinition rpcDef) throws NoSuchMethodException {
        String methodName = BindingMapping.getMethodName((QName)rpcDef.getQName());
        Class inputClz = this.runtimeContext().getClassForSchema((SchemaNode)rpcDef.getInput());
        return key.getMethod(methodName, inputClz);
    }

    public final BindingCodecTree create(BindingRuntimeContext context) {
        return this.codecRegistry.create(context);
    }

    public final BindingCodecTree create(SchemaContext context, Class<?> ... bindingClasses) {
        return this.codecRegistry.create(context, (Class[])bindingClasses);
    }

    protected  @NonNull Map.Entry<InstanceIdentifier<?>, BindingCodecTreeNode<?>> getSubtreeCodec(YangInstanceIdentifier domIdentifier) {
        BindingCodecTree currentCodecTree = this.codecRegistry.getCodecContext();
        InstanceIdentifier bindingPath = this.codecRegistry.fromYangInstanceIdentifier(domIdentifier);
        Preconditions.checkArgument((bindingPath != null ? 1 : 0) != 0);
        BindingCodecTreeNode codecContext = currentCodecTree.getSubtreeCodec(bindingPath);
        return new AbstractMap.SimpleEntry(bindingPath, codecContext);
    }

    public final Set<Class<? extends Notification>> getNotificationClasses(Set<SchemaPath> interested) {
        HashSet<Class<? extends Notification>> result = new HashSet<Class<? extends Notification>>();
        BindingRuntimeContext runtimeContext = this.runtimeContext();
        for (NotificationDefinition notification : runtimeContext.getSchemaContext().getNotifications()) {
            if (!interested.contains(notification.getPath())) continue;
            try {
                result.add(runtimeContext.getClassForSchema((SchemaNode)notification));
            }
            catch (IllegalStateException e) {
                LOG.warn("Class for {} is currently not known.", (Object)notification.getPath(), (Object)e);
            }
        }
        return result;
    }

    SchemaPath getActionPath(Class<? extends Action<?, ?, ?>> type) {
        ActionDefinition schema = this.runtimeContext().getActionDefinition(type);
        Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Failed to find schema for %s", type);
        return schema.getPath();
    }

    private BindingRuntimeContext runtimeContext() {
        return this.futureSchema.runtimeContext();
    }

    private static Collection<Class<?>> decompose(InstanceIdentifier<?> path) {
        return ImmutableSet.copyOf((Iterator)Iterators.transform(path.getPathArguments().iterator(), InstanceIdentifier.PathArgument::getType));
    }

    protected NormalizedNode<?, ?> instanceIdentifierToNode(YangInstanceIdentifier parentPath) {
        return ImmutableNodes.fromInstanceId((SchemaContext)this.runtimeContext().getSchemaContext(), (YangInstanceIdentifier)parentPath);
    }

    @Deprecated
    public NormalizedNode<?, ?> getDefaultNodeFor(YangInstanceIdentifier parentMapPath) {
        BindingCodecTreeNode mapCodec = Objects.requireNonNull(this.codecRegistry.getCodecContext().getSubtreeCodec(parentMapPath), "Codec not found for yang instance identifier: " + parentMapPath);
        DocumentedNode.WithStatus schema = mapCodec.getSchema();
        if (schema instanceof ListSchemaNode) {
            ListSchemaNode castedSchema = (ListSchemaNode)schema;
            return castedSchema.isUserOrdered() ? Builders.orderedMapBuilder((ListSchemaNode)castedSchema).build() : Builders.mapBuilder((ListSchemaNode)castedSchema).build();
        }
        throw new IllegalArgumentException("Path does not point to list schema node");
    }

    protected Collection<DOMDataTreeIdentifier> toDOMDataTreeIdentifiers(Collection<DataTreeIdentifier<?>> subtrees) {
        return subtrees.stream().map(this::toDOMDataTreeIdentifier).collect(Collectors.toSet());
    }

    protected DOMDataTreeIdentifier toDOMDataTreeIdentifier(DataTreeIdentifier<?> path) {
        YangInstanceIdentifier domPath = this.toYangInstanceIdentifierBlocking((InstanceIdentifier<? extends DataObject>)path.getRootIdentifier());
        return new DOMDataTreeIdentifier(path.getDatastoreType(), domPath);
    }
}

