/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataObjectModification;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataObjectModification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

final class LazyDataTreeModification<T extends DataObject>
implements DataTreeModification<T> {
    private final @NonNull DataTreeIdentifier<T> path;
    private final @NonNull DataObjectModification<T> rootNode;

    private LazyDataTreeModification(DataTreeIdentifier<T> path, DataObjectModification<T> modification) {
        this.path = Objects.requireNonNull(path);
        this.rootNode = Objects.requireNonNull(modification);
    }

    static <T extends DataObject> DataTreeModification<T> create(BindingToNormalizedNodeCodec codec, DataTreeCandidate domChange, LogicalDatastoreType datastoreType) {
        Map.Entry<InstanceIdentifier<?>, BindingCodecTreeNode<?>> codecCtx = codec.getSubtreeCodec(domChange.getRootPath());
        DataTreeIdentifier path = DataTreeIdentifier.create((LogicalDatastoreType)datastoreType, codecCtx.getKey());
        LazyDataObjectModification<?> modification = LazyDataObjectModification.create(codecCtx.getValue(), domChange.getRootNode());
        return new LazyDataTreeModification(path, modification);
    }

    static <T extends DataObject> DataTreeModification<T> create(BindingToNormalizedNodeCodec codec, DOMDataTreeCandidate candidate) {
        Map.Entry<InstanceIdentifier<?>, BindingCodecTreeNode<?>> codecCtx = codec.getSubtreeCodec(candidate.getRootPath().getRootIdentifier());
        DataTreeIdentifier path = DataTreeIdentifier.create((LogicalDatastoreType)candidate.getRootPath().getDatastoreType(), codecCtx.getKey());
        LazyDataObjectModification<?> modification = LazyDataObjectModification.create(codecCtx.getValue(), candidate.getRootNode());
        return new LazyDataTreeModification(path, modification);
    }

    static <T extends DataObject> @NonNull Collection<DataTreeModification<T>> from(BindingToNormalizedNodeCodec codec, Collection<DataTreeCandidate> domChanges, LogicalDatastoreType datastoreType) {
        ArrayList<DataTreeModification<T>> result = new ArrayList<DataTreeModification<T>>(domChanges.size());
        for (DataTreeCandidate domChange : domChanges) {
            result.add(LazyDataTreeModification.create(codec, domChange, datastoreType));
        }
        return result;
    }

    public DataObjectModification<T> getRootNode() {
        return this.rootNode;
    }

    public DataTreeIdentifier<T> getRootPath() {
        return this.path;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", this.path).add("rootNode", this.rootNode).toString();
    }
}

