/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDataAware;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.dom.codec.util.AbstractBindingLazyContainerNode;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

class LazySerializedContainerNode
extends AbstractBindingLazyContainerNode<DataObject, BindingNormalizedNodeCodecRegistry>
implements BindingDataAware {
    private LazySerializedContainerNode(QName identifier, DataObject binding, BindingNormalizedNodeCodecRegistry registry) {
        super(YangInstanceIdentifier.NodeIdentifier.create((QName)identifier), binding, (Object)Objects.requireNonNull(registry));
    }

    static ContainerNode create(SchemaPath rpcName, DataObject data, BindingNormalizedNodeCodecRegistry codec) {
        return data == null ? null : new LazySerializedContainerNode(rpcName.getLastComponent(), data, codec);
    }

    static ContainerNode withContextRef(SchemaPath rpcName, DataObject data, LeafNode<?> contextRef, BindingNormalizedNodeCodecRegistry codec) {
        return new WithContextRef(rpcName.getLastComponent(), data, contextRef, codec);
    }

    @Override
    public final DataObject bindingData() {
        return this.getDataObject();
    }

    protected final ContainerNode computeContainerNode(BindingNormalizedNodeCodecRegistry context) {
        return context.toNormalizedNodeRpcData((DataContainer)this.getDataObject());
    }

    private static final class WithContextRef
    extends LazySerializedContainerNode {
        private final LeafNode<?> contextRef;

        protected WithContextRef(QName identifier, DataObject binding, LeafNode<?> contextRef, BindingNormalizedNodeCodecRegistry registry) {
            super(identifier, binding, registry);
            this.contextRef = Objects.requireNonNull(contextRef);
        }

        public Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChild(YangInstanceIdentifier.PathArgument child) {
            return ((YangInstanceIdentifier.NodeIdentifier)this.contextRef.getIdentifier()).equals((Object)child) ? Optional.of(this.contextRef) : super.getChild(child);
        }
    }
}

