/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter.invoke;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcMethodInvoker;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.RpcServiceInvoker;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMappedRpcInvoker<T>
extends RpcServiceInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMappedRpcInvoker.class);
    @VisibleForTesting
    final Map<T, RpcMethodInvoker> map;

    protected AbstractMappedRpcInvoker(Map<T, Method> map) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<T, Method> e : map.entrySet()) {
            if (BindingReflections.isRpcMethod((Method)e.getValue())) {
                b.put(e.getKey(), (Object)RpcMethodInvoker.from(e.getValue()));
                continue;
            }
            LOG.debug("Method {} is not an RPC method, ignoring it", (Object)e.getValue());
        }
        this.map = b.build();
    }

    protected abstract T qnameToKey(QName var1);

    @Override
    public final ListenableFuture<RpcResult<?>> invokeRpc(RpcService impl, QName rpcName, DataObject input) {
        Objects.requireNonNull(impl, "Implementation must be supplied");
        RpcMethodInvoker invoker = this.map.get(this.qnameToKey(rpcName));
        Preconditions.checkArgument((invoker != null ? 1 : 0) != 0, (String)"Supplied RPC is not valid for implementation %s", (Object)impl);
        return invoker.invokeOn(impl, input);
    }
}

