/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command.ds;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Command(scope="jdbc", name="ds-list", description="List the JDBC datasources")
@Service
public class ListCommand
extends JdbcCommandSupport {
    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("Name");
        table.column("Service Id");
        table.column("Product");
        table.column("Version");
        table.column("URL");
        table.column("Status");
        boolean duplication = false;
        HashMap<String, Long> nameToId = new HashMap<String, Long>();
        List<Long> datasources = this.getJdbcService().datasourceServiceIds();
        Collections.sort(datasources);
        for (Long id : datasources) {
            try {
                Map<String, String> info = this.getJdbcService().info(Long.toString(id));
                table.addRow().addContent(new Object[]{info.get("name"), info.get("service.id"), info.get("db.product"), info.get("db.version"), info.get("url"), "OK"});
                if (nameToId.put(info.get("name"), id) == null) continue;
                duplication = true;
            }
            catch (Exception e) {
                table.addRow().addContent(new Object[]{id, "", "", "", "", "Error " + e.getMessage()});
            }
        }
        table.print(System.out);
        if (duplication) {
            System.out.println("\nThere are multiple data source services registered with the same name. Please review your configuration.");
        }
        return null;
    }
}

