/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.jdbc.mssql.impl;

import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.ops4j.pax.jdbc.common.BeanConfig;
import org.osgi.service.jdbc.DataSourceFactory;

public class MSSQLDataSourceFactory
implements DataSourceFactory {
    private static final String MSSQL_DRIVER_FQCN = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String MSSQL_DATASOURCE_FQCN = "com.microsoft.sqlserver.jdbc.SQLServerDataSource";
    private static final String MSSQL_CONNECTIONPOOL_DATASOURCE_FQCN = "com.microsoft.sqlserver.jdbc.SQLServerConnectionPoolDataSource";
    private static final String MSSQL_XA_DATASOURCE_FQCN = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
    private final Class<?> mssqlDriverClass;
    private final Class<?> mssqlDataSourceClass;
    private final Class<?> mssqlConnectionPoolDataSourceClass;
    private final Class<?> mssqlXADataSourceClass;

    public MSSQLDataSourceFactory() throws ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.mssqlDriverClass = classLoader.loadClass(MSSQL_DRIVER_FQCN);
        this.mssqlDataSourceClass = classLoader.loadClass(MSSQL_DATASOURCE_FQCN);
        this.mssqlConnectionPoolDataSourceClass = classLoader.loadClass(MSSQL_CONNECTIONPOOL_DATASOURCE_FQCN);
        this.mssqlXADataSourceClass = classLoader.loadClass(MSSQL_XA_DATASOURCE_FQCN);
    }

    public DataSource createDataSource(Properties props) throws SQLException {
        try {
            return (DataSource)this.setProperties(this.mssqlDataSourceClass.newInstance(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        try {
            return (ConnectionPoolDataSource)this.setProperties(this.mssqlConnectionPoolDataSourceClass.newInstance(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        try {
            return (XADataSource)this.setProperties(this.mssqlXADataSourceClass.newInstance(), props);
        }
        catch (Exception ex) {
            throw new SQLException(ex);
        }
    }

    public Driver createDriver(Properties props) throws SQLException {
        try {
            return (Driver)Driver.class.cast(this.mssqlDriverClass.newInstance());
        }
        catch (InstantiationException ex) {
            throw new SQLException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new SQLException(ex);
        }
    }

    private <T> T setProperties(Object dataSourceInstance, Properties props) throws Exception {
        String url = (String)props.remove("url");
        this.setProperty(url, dataSourceInstance, "setURL");
        String databaseName = (String)props.remove("databaseName");
        this.setProperty(databaseName, dataSourceInstance, "setDatabaseName");
        String serverName = (String)props.remove("serverName");
        this.setProperty(serverName, dataSourceInstance, "setServerName");
        String portNumber = (String)props.remove("portNumber");
        this.setIntProperty(portNumber, dataSourceInstance, "setPortNumber");
        String user = (String)props.remove("user");
        this.setProperty(user, dataSourceInstance, "setUser");
        String password = (String)props.remove("password");
        this.setProperty(password, dataSourceInstance, "setPassword");
        if (!props.isEmpty()) {
            BeanConfig.configure(dataSourceInstance, props);
        }
        return (T)dataSourceInstance;
    }

    private void setProperty(String value, Object instance, String methodName) throws Exception {
        if (value != null) {
            instance.getClass().getMethod(methodName, String.class).invoke(instance, value);
        }
    }

    private void setIntProperty(String value, Object instance, String methodName) throws Exception {
        if (value != null) {
            int iValue = new Integer(value);
            instance.getClass().getMethod(methodName, Integer.TYPE).invoke(instance, iValue);
        }
    }
}

