/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.jsonrpc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;

public abstract class JsonRpcBaseRequestMessage
extends JsonRpcBaseMessage {
    private final String method;
    private final JsonElement params;

    protected JsonRpcBaseRequestMessage(AbstractRequestBuilder<?, ?> builder) {
        super(builder);
        this.method = Objects.requireNonNull(((AbstractRequestBuilder)builder).method);
        this.params = ((AbstractRequestBuilder)builder).params;
    }

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    @Nullable
    public JsonElement getParams() {
        return this.params;
    }

    public <T> T getParamsAsObject(Class<T> cls) throws JsonRpcException {
        return JsonRpcBaseRequestMessage.convertJsonElementToClass(this.getParams(), cls);
    }

    public <T> T getParamsAtIndexAsObject(int index, Class<T> cls) throws JsonRpcException {
        if (this.params.isJsonArray()) {
            JsonArray paramArray = this.params.getAsJsonArray();
            if (index < paramArray.size()) {
                return JsonRpcBaseRequestMessage.convertJsonElementToClass(paramArray.get(index), cls);
            }
        } else if (index == 0) {
            return JsonRpcBaseRequestMessage.convertJsonElementToClass(this.params, cls);
        }
        return null;
    }

    protected static abstract class AbstractRequestBuilder<T extends AbstractRequestBuilder<T, M>, M extends JsonRpcBaseMessage>
    extends JsonRpcBaseMessage.AbstractBuilder<T, M> {
        private String method;
        private JsonElement params;

        protected AbstractRequestBuilder() {
        }

        public T method(String value) {
            this.method = value;
            return (T)((AbstractRequestBuilder)this.self());
        }

        public T params(JsonElement value) {
            this.params = value;
            return (T)((AbstractRequestBuilder)this.self());
        }

        public T paramsFromObject(Object obj) {
            return this.params(obj != null ? JsonRpcBaseMessage.convertClassToJsonElement(obj) : null);
        }
    }
}

