/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.jsonrpc;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

public class JsonRpcErrorObject {
    public static final String JSONRPC_ERROR_MESSAGE_INTERNAL = "Internal error";
    private int code;
    private String message;
    private JsonElement data;

    public JsonRpcErrorObject() {
        this.message = null;
        this.code = 0;
        this.data = null;
    }

    public JsonRpcErrorObject(Integer code, String message, JsonElement data) {
        this.message = message;
        this.code = code;
        this.data = data;
    }

    public JsonRpcErrorObject(JsonElement elem) {
        this();
        JsonObject obj;
        if (elem != null && (obj = elem.getAsJsonObject()) != null) {
            this.setCode(obj.get("code"));
            this.setMessage(obj.get("message"));
            this.setData(obj.get("data"));
        }
    }

    public String getMessage() {
        return this.message;
    }

    private void setMessage(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            this.setMessage(element.getAsString());
        }
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    private void setCode(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            this.setCode(element.getAsInt());
        }
    }

    public void setCode(int code) {
        this.code = code;
    }

    public JsonElement getData() {
        return this.data;
    }

    public void setData(JsonElement data) {
        this.data = data;
    }

    public String toString() {
        return "JsonRpcErrorObject [code=" + this.code + ", message=" + this.message + ", data=" + this.data + "]";
    }
}

