/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.jsonrpc;

import com.google.gson.JsonElement;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcException;

public final class JsonRpcMessageError
extends JsonRpcBaseMessage {
    private final int code;
    private final String message;
    private final JsonElement data;

    private JsonRpcMessageError(Builder builder) {
        super(builder);
        this.code = builder.code;
        this.message = Objects.requireNonNull(builder.message);
        this.data = builder.data;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    public int getCode() {
        return this.code;
    }

    @Nullable
    public JsonElement getData() {
        return this.data;
    }

    public <T> T getDataAsObject(Class<T> cls) throws JsonRpcException {
        return JsonRpcMessageError.convertJsonElementToClass(this.getData(), cls);
    }

    @Override
    public JsonRpcBaseMessage.JsonRpcMessageType getType() {
        return JsonRpcBaseMessage.JsonRpcMessageType.PARSE_ERROR;
    }

    public String toString() {
        return "JsonRpcMessageError [id=" + this.getId() + ", code=" + this.code + ", message=" + this.message + ", data=" + this.data + "]";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends JsonRpcBaseMessage.AbstractBuilder<Builder, JsonRpcMessageError> {
        private int code;
        private String message;
        private JsonElement data;

        public Builder code(int value) {
            this.code = value;
            return this;
        }

        public Builder message(String value) {
            this.message = value;
            return this;
        }

        public Builder data(JsonElement value) {
            this.data = value;
            return this;
        }

        public Builder dataFromObject(Object obj) {
            return this.data(JsonRpcBaseMessage.convertClassToJsonElement(obj));
        }

        @Override
        protected JsonRpcMessageError newInstance() {
            return new JsonRpcMessageError(this);
        }
    }
}

