/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.jsonrpc.bus.jsonrpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcBaseMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcErrorObject;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcMessageError;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcMessageErrorSerializer;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcNotificationMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcNotificationMessageSerializer;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcReplyMessageSerializer;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcRequestMessage;
import org.opendaylight.jsonrpc.bus.jsonrpc.JsonRpcRequestMessageSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonRpcSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcSerializer.class);

    private JsonRpcSerializer() {
    }

    private static JsonRpcBaseMessage processOneElement(JsonElement elem) {
        JsonObject obj = elem.getAsJsonObject();
        if (obj == null) {
            return JsonRpcMessageError.builder().code(-32700).message("Unable to parse object").build();
        }
        JsonElement id = obj.get("id");
        JsonElement jsonrpcElem = obj.get("jsonrpc");
        if (jsonrpcElem == null || jsonrpcElem.isJsonNull()) {
            return ((JsonRpcMessageError.Builder)JsonRpcMessageError.builder().id(id)).code(-32700).message("JSON RPC version is not defined").build();
        }
        String jsonrpc = jsonrpcElem.getAsString();
        if (!JsonRpcBaseMessage.isSupportedVersion(jsonrpc)) {
            JsonObject data = new JsonObject();
            data.addProperty("jsonrpc", jsonrpc);
            return ((JsonRpcMessageError.Builder)JsonRpcMessageError.builder().id(id)).code(-32700).data((JsonElement)data).message("JSON RPC version is not supported").build();
        }
        if (obj.has("method")) {
            if (obj.has("error") || obj.has("result")) {
                return ((JsonRpcMessageError.Builder)JsonRpcMessageError.builder().id(id)).code(-32700).message("Request message has error or result").build();
            }
            if (id != null) {
                return JsonRpcSerializer.processRequestMessage(obj, id);
            }
            return JsonRpcSerializer.processNotificationMessage(obj);
        }
        return JsonRpcSerializer.processReplyMessage(obj, id);
    }

    private static JsonRpcBaseMessage processReplyMessage(JsonObject obj, JsonElement id) {
        if (obj.has("result")) {
            if (obj.has("error")) {
                return ((JsonRpcMessageError.Builder)JsonRpcMessageError.builder().id(id)).code(-32700).message("Reply has both error and result").build();
            }
            if (obj.has("metadata")) {
                return ((JsonRpcReplyMessage.Builder)((JsonRpcReplyMessage.Builder)JsonRpcReplyMessage.builder().id(id)).result(obj.get("result")).metadata(obj.get("metadata").getAsJsonObject())).build();
            }
            return ((JsonRpcReplyMessage.Builder)JsonRpcReplyMessage.builder().id(id)).result(obj.get("result")).build();
        }
        if (obj.has("error")) {
            return ((JsonRpcReplyMessage.Builder)JsonRpcReplyMessage.builder().id(id)).error(new JsonRpcErrorObject(obj.get("error"))).build();
        }
        return ((JsonRpcMessageError.Builder)JsonRpcMessageError.builder().id(id)).code(-32700).message("Reply has neither error nor result").build();
    }

    private static JsonRpcBaseMessage processRequestMessage(JsonObject obj, JsonElement id) {
        if (obj.has("metadata")) {
            return ((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)JsonRpcRequestMessage.builder().id(id)).method(obj.get("method").getAsString())).params(obj.get("params"))).metadata(obj.get("metadata").getAsJsonObject())).build();
        }
        return ((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)((JsonRpcRequestMessage.Builder)JsonRpcRequestMessage.builder().id(id)).method(obj.get("method").getAsString())).params(obj.get("params"))).build();
    }

    private static JsonRpcBaseMessage processNotificationMessage(JsonObject obj) {
        if (obj.has("metadata")) {
            return ((JsonRpcNotificationMessage.Builder)((JsonRpcNotificationMessage.Builder)((JsonRpcNotificationMessage.Builder)JsonRpcNotificationMessage.builder().method(obj.get("method").getAsString())).params(obj.get("params"))).metadata(obj.get("metadata").getAsJsonObject())).build();
        }
        return ((JsonRpcNotificationMessage.Builder)((JsonRpcNotificationMessage.Builder)JsonRpcNotificationMessage.builder().method(obj.get("method").getAsString())).params(obj.get("params"))).build();
    }

    public static List<JsonRpcBaseMessage> fromJson(String strJson) {
        JsonElement parsedJson;
        Gson gson = new Gson();
        ArrayList<JsonRpcBaseMessage> list = new ArrayList<JsonRpcBaseMessage>();
        try {
            parsedJson = (JsonElement)gson.fromJson(strJson, JsonElement.class);
        }
        catch (JsonSyntaxException e) {
            LOG.debug("Unable to parse JSON message", (Throwable)e);
            parsedJson = null;
        }
        if (parsedJson == null) {
            JsonRpcMessageError err = (JsonRpcMessageError)JsonRpcMessageError.builder().code(-32700).message("Unable to parse incoming message").build();
            list.add(err);
            return list;
        }
        if (parsedJson.isJsonArray()) {
            for (JsonElement e : parsedJson.getAsJsonArray()) {
                list.add(JsonRpcSerializer.processOneElement(e));
            }
        } else if (parsedJson.isJsonObject()) {
            list.add(JsonRpcSerializer.processOneElement(parsedJson));
        } else {
            JsonRpcMessageError err = (JsonRpcMessageError)JsonRpcMessageError.builder().code(-32700).message("Unable to determine incoming message").build();
            list.add(err);
        }
        return list;
    }

    private static String toJson(Object obj) {
        Gson gson = new GsonBuilder().registerTypeAdapter(JsonRpcMessageError.class, (Object)new JsonRpcMessageErrorSerializer()).registerTypeAdapter(JsonRpcReplyMessage.class, (Object)new JsonRpcReplyMessageSerializer()).registerTypeAdapter(JsonRpcRequestMessage.class, (Object)new JsonRpcRequestMessageSerializer()).registerTypeAdapter(JsonRpcNotificationMessage.class, (Object)new JsonRpcNotificationMessageSerializer()).serializeNulls().create();
        return gson.toJson(obj);
    }

    public static String toJson(JsonRpcBaseMessage msg) {
        return JsonRpcSerializer.toJson((Object)msg);
    }

    public static String toJson(List<JsonRpcBaseMessage> msg) {
        return JsonRpcSerializer.toJson(msg.toArray());
    }
}

