/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.netconf.sal.rest.impl;

import com.google.common.base.Optional;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.opendaylight.netconf.sal.rest.api.RestconfNormalizedNodeWriter;
import org.opendaylight.netconf.sal.rest.impl.DepthAwareNormalizedNodeWriter;
import org.opendaylight.netconf.sal.rest.impl.RestconfDelegatingNormalizedNodeWriter;
import org.opendaylight.restconf.common.context.InstanceIdentifierContext;
import org.opendaylight.restconf.common.context.NormalizedNodeContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactorySupplier;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.codec.gson.JsonWriterFactory;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

@Deprecated
@Provider
@Produces(value={"application/yang.api+json", "application/yang.data+json", "application/yang.operation+json", "application/json"})
public class NormalizedNodeJsonBodyWriter
implements MessageBodyWriter<NormalizedNodeContext> {
    private static final int DEFAULT_INDENT_SPACES_NUM = 2;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.equals(NormalizedNodeContext.class);
    }

    public long getSize(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(NormalizedNodeContext context, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        NormalizedNode data;
        if (httpHeaders != null) {
            for (Map.Entry entry : context.getNewHeaders().entrySet()) {
                httpHeaders.add(entry.getKey(), entry.getValue());
            }
        }
        if ((data = context.getData()) == null) {
            return;
        }
        InstanceIdentifierContext identifierCtx = context.getInstanceIdentifierContext();
        SchemaPath path = identifierCtx.getSchemaNode().getPath();
        try (JsonWriter jsonWriter = NormalizedNodeJsonBodyWriter.createJsonWriter(entityStream, context.getWriterParameters().isPrettyPrint());){
            jsonWriter.beginObject();
            NormalizedNodeJsonBodyWriter.writeNormalizedNode(jsonWriter, path, (InstanceIdentifierContext<SchemaNode>)identifierCtx, data, (Optional<Integer>)Optional.fromNullable((Object)context.getWriterParameters().getDepth()));
            jsonWriter.endObject();
            jsonWriter.flush();
        }
    }

    private static void writeNormalizedNode(JsonWriter jsonWriter, SchemaPath path, InstanceIdentifierContext<SchemaNode> context, NormalizedNode<?, ?> data, Optional<Integer> depth) throws IOException {
        RestconfNormalizedNodeWriter nnWriter;
        if (SchemaPath.ROOT.equals((Object)path)) {
            nnWriter = NormalizedNodeJsonBodyWriter.createNormalizedNodeWriter(context, path, jsonWriter, depth);
            NormalizedNodeJsonBodyWriter.writeChildren(nnWriter, (ContainerNode)data);
        } else if (context.getSchemaNode() instanceof RpcDefinition) {
            path = ((RpcDefinition)context.getSchemaNode()).getOutput().getPath();
            nnWriter = NormalizedNodeJsonBodyWriter.createNormalizedNodeWriter(context, path, jsonWriter, depth);
            jsonWriter.name("output");
            jsonWriter.beginObject();
            NormalizedNodeJsonBodyWriter.writeChildren(nnWriter, (ContainerNode)data);
            jsonWriter.endObject();
        } else {
            path = path.getParent();
            if (data instanceof MapEntryNode) {
                data = ImmutableNodes.mapNodeBuilder((QName)data.getNodeType()).withChild((NormalizedNode)((MapEntryNode)data)).build();
            }
            nnWriter = NormalizedNodeJsonBodyWriter.createNormalizedNodeWriter(context, path, jsonWriter, depth);
            nnWriter.write(data);
        }
        nnWriter.flush();
    }

    private static void writeChildren(RestconfNormalizedNodeWriter nnWriter, ContainerNode data) throws IOException {
        for (DataContainerChild child : data.getValue()) {
            nnWriter.write((NormalizedNode<?, ?>)child);
        }
    }

    private static RestconfNormalizedNodeWriter createNormalizedNodeWriter(InstanceIdentifierContext<SchemaNode> context, SchemaPath path, JsonWriter jsonWriter, Optional<Integer> depth) {
        SchemaNode schema = context.getSchemaNode();
        JSONCodecFactory codecs = NormalizedNodeJsonBodyWriter.getCodecFactory(context);
        URI initialNs = schema instanceof DataSchemaNode && !((DataSchemaNode)schema).isAugmenting() && !(schema instanceof SchemaContext) ? schema.getQName().getNamespace() : (schema instanceof RpcDefinition ? schema.getQName().getNamespace() : null);
        NormalizedNodeStreamWriter streamWriter = JSONNormalizedNodeStreamWriter.createNestedWriter((JSONCodecFactory)codecs, (SchemaPath)path, (URI)initialNs, (JsonWriter)jsonWriter);
        if (depth.isPresent()) {
            return DepthAwareNormalizedNodeWriter.forStreamWriter(streamWriter, (Integer)depth.get());
        }
        return RestconfDelegatingNormalizedNodeWriter.forStreamWriter(streamWriter);
    }

    private static JsonWriter createJsonWriter(OutputStream entityStream, boolean prettyPrint) {
        if (prettyPrint) {
            return JsonWriterFactory.createJsonWriter((Writer)new OutputStreamWriter(entityStream, StandardCharsets.UTF_8), (int)2);
        }
        return JsonWriterFactory.createJsonWriter((Writer)new OutputStreamWriter(entityStream, StandardCharsets.UTF_8));
    }

    private static JSONCodecFactory getCodecFactory(InstanceIdentifierContext<?> context) {
        return JSONCodecFactorySupplier.DRAFT_LHOTKA_NETMOD_YANG_JSON_02.getShared(context.getSchemaContext());
    }
}

